/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.client.renderer.MyRenderType;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.util.CodecHelpers;
import com.direwolf20.mininggadgets.setup.Registration;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class RenderMiningLaser {
    private static final ResourceLocation laserBeam = ResourceLocation.fromNamespaceAndPath((String)"mininggadgets", (String)"textures/misc/laser.png");
    private static final ResourceLocation laserBeam2 = ResourceLocation.fromNamespaceAndPath((String)"mininggadgets", (String)"textures/misc/laser2.png");
    private static final ResourceLocation laserBeamGlow = ResourceLocation.fromNamespaceAndPath((String)"mininggadgets", (String)"textures/misc/laser_glow.png");

    public static void renderLaser(RenderLevelStageEvent event, Player player, float ticks) {
        ItemStack stack = MiningGadget.getGadget(player);
        if (!MiningProperties.getCanMine(stack)) {
            return;
        }
        int range = MiningProperties.getBeamRange(stack);
        Vec3 playerPos = player.getEyePosition(ticks);
        HitResult trace = player.pick((double)range, ticks, false);
        float speedModifier = RenderMiningLaser.getSpeedModifier(stack);
        CodecHelpers.LaserColor laserColor = MiningProperties.getColors(stack);
        float red = (float)laserColor.red() / 255.0f;
        float green = (float)laserColor.green() / 255.0f;
        float blue = (float)laserColor.blue() / 255.0f;
        RenderMiningLaser.drawLasers(stack, event, playerPos, trace, 0.0, 0.0, 0.0, red, green, blue, 0.02f, player, ticks, speedModifier);
    }

    private static float getSpeedModifier(ItemStack stack) {
        if (UpgradeTools.containsUpgrade(stack, Upgrade.EFFICIENCY_1)) {
            double efficiency = (float)UpgradeTools.getUpgradeFromGadget(stack, Upgrade.EFFICIENCY_1).get().getTier() / 5.0f;
            double speedModifier = Mth.lerp((double)efficiency, (double)0.02, (double)0.05);
            return (float)(-speedModifier);
        }
        return -0.02f;
    }

    private static void drawLasers(ItemStack stack, RenderLevelStageEvent event, Vec3 from, HitResult trace, double xOffset, double yOffset, double zOffset, float r, float g, float b, float thickness, Player player, float ticks, float speedModifier) {
        InteractionHand activeHand;
        if (player.getMainHandItem().getItem() instanceof MiningGadget) {
            activeHand = InteractionHand.MAIN_HAND;
        } else if (player.getOffhandItem().getItem() instanceof MiningGadget) {
            activeHand = InteractionHand.OFF_HAND;
        } else {
            return;
        }
        double distance = Math.max(1.0, from.subtract(trace.getLocation()).length());
        long gameTime = player.level().getGameTime();
        double v = (float)gameTime * speedModifier;
        float additiveThickness = thickness * 3.5f * RenderMiningLaser.calculateLaserFlickerModifier(gameTime);
        CodecHelpers.LaserColor laserColor = MiningProperties.getColors(stack);
        float beam2r = (float)laserColor.innerRed() / 255.0f;
        float beam2g = (float)laserColor.innerGreen() / 255.0f;
        float beam2b = (float)laserColor.innerBlue() / 255.0f;
        Vec3 view = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        PoseStack matrix = event.getPoseStack();
        matrix.pushPose();
        matrix.translate(-view.x(), -view.y(), -view.z());
        matrix.translate(from.x, from.y, from.z);
        matrix.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)ticks, (float)(-player.getYRot()), (float)(-player.yRotO))));
        matrix.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)ticks, (float)player.getXRot(), (float)player.xRotO)));
        PoseStack.Pose matrixstack$entry = matrix.last();
        Matrix3f matrixNormal = matrixstack$entry.normal();
        Matrix4f positionMatrix = matrixstack$entry.pose();
        VertexConsumer builder = buffer.getBuffer(MyRenderType.LASER_MAIN_ADDITIVE);
        RenderMiningLaser.drawBeam(stack, xOffset, yOffset, zOffset, builder, positionMatrix, matrixNormal, additiveThickness, activeHand, distance, 0.5, 1.0, ticks, r, g, b, 0.7f);
        builder = buffer.getBuffer(MyRenderType.LASER_MAIN_BEAM);
        RenderMiningLaser.drawBeam(stack, xOffset, yOffset, zOffset, builder, positionMatrix, matrixNormal, thickness, activeHand, distance, v, v + distance * 1.5, ticks, r, g, b, 1.0f);
        builder = buffer.getBuffer(MyRenderType.LASER_MAIN_CORE);
        RenderMiningLaser.drawBeam(stack, xOffset, yOffset, zOffset, builder, positionMatrix, matrixNormal, thickness / 2.0f, activeHand, distance, v, v + distance * 1.5, ticks, beam2r, beam2g, beam2b, 1.0f);
        matrix.popPose();
        buffer.endBatch();
    }

    private static float calculateLaserFlickerModifier(long gameTime) {
        return 0.9f + 0.1f * Mth.sin((float)((float)gameTime * 0.99f)) * Mth.sin((float)((float)gameTime * 0.3f)) * Mth.sin((float)((float)gameTime * 0.1f));
    }

    private static void drawBeam(ItemStack stack, double xOffset, double yOffset, double zOffset, VertexConsumer builder, Matrix4f positionMatrix, Matrix3f matrixNormalIn, float thickness, InteractionHand hand, double distance, double v1, double v2, float ticks, float r, float g, float b, float alpha) {
        boolean isFancy = stack.getItem().equals(Registration.MININGGADGET_FANCY.get());
        boolean isSimple = stack.getItem().equals(Registration.MININGGADGET_SIMPLE.get());
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        vector3f.mul((Matrix3fc)matrixNormalIn);
        LocalPlayer player = Minecraft.getInstance().player;
        if (Minecraft.getInstance().options.mainHand().get() != HumanoidArm.RIGHT) {
            hand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        }
        float startXOffset = -0.2f;
        float startYOffset = -0.108f;
        float startZOffset = 0.6f;
        if (isFancy) {
            startYOffset += 0.02f;
        }
        if (isSimple) {
            startXOffset -= 0.02f;
            startZOffset += 0.05f;
            startYOffset -= 0.005f;
        }
        float fov = player.getFieldOfViewModifier();
        float fovSetting = ((Integer)Minecraft.getInstance().options.fov().get()).intValue();
        float fovSettingAdjuster = 0.0f;
        if (fovSetting != 70.0f) {
            float f = fovSettingAdjuster = fovSetting < 70.0f ? fovSetting / 70.0f / 0.5f : -(fovSetting / 70.0f) / 6.0f;
        }
        startZOffset = fov >= 1.0f ? (startZOffset += (1.0f - fov) * 0.5f + fovSettingAdjuster) : (startZOffset += (1.0f - fov) * 1.5f + fovSettingAdjuster);
        if (hand == InteractionHand.OFF_HAND) {
            startYOffset = -0.12f;
            startXOffset = 0.25f;
        }
        float f = Mth.lerp((float)ticks, (float)player.xRotO, (float)player.getXRot()) - Mth.lerp((float)ticks, (float)player.xBobO, (float)player.xBob);
        float f1 = Mth.lerp((float)ticks, (float)player.yRotO, (float)player.getYRot()) - Mth.lerp((float)ticks, (float)player.yBobO, (float)player.yBob);
        Vector4f vec1 = new Vector4f(startXOffset += f1 / 750.0f, -thickness + (startYOffset += f / 750.0f), startZOffset, 1.0f);
        vec1.mul((Matrix4fc)positionMatrix);
        Vector4f vec2 = new Vector4f((float)xOffset, -thickness + (float)yOffset, (float)distance + (float)zOffset, 1.0f);
        vec2.mul((Matrix4fc)positionMatrix);
        Vector4f vec3 = new Vector4f((float)xOffset, thickness + (float)yOffset, (float)distance + (float)zOffset, 1.0f);
        vec3.mul((Matrix4fc)positionMatrix);
        Vector4f vec4 = new Vector4f(startXOffset, thickness + startYOffset, startZOffset, 1.0f);
        vec4.mul((Matrix4fc)positionMatrix);
        if (hand == InteractionHand.MAIN_HAND) {
            builder.addVertex(vec4.x(), vec4.y(), vec4.z()).setColor(r, g, b, alpha).setUv(0.0f, (float)v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec3.x(), vec3.y(), vec3.z()).setColor(r, g, b, alpha).setUv(0.0f, (float)v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec2.x(), vec2.y(), vec2.z()).setColor(r, g, b, alpha).setUv(1.0f, (float)v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec1.x(), vec1.y(), vec1.z()).setColor(r, g, b, alpha).setUv(1.0f, (float)v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec1.x(), vec1.y(), vec1.z()).setColor(r, g, b, alpha).setUv(1.0f, (float)v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec2.x(), vec2.y(), vec2.z()).setColor(r, g, b, alpha).setUv(1.0f, (float)v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec3.x(), vec3.y(), vec3.z()).setColor(r, g, b, alpha).setUv(0.0f, (float)v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec4.x(), vec4.y(), vec4.z()).setColor(r, g, b, alpha).setUv(0.0f, (float)v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
        } else {
            builder.addVertex(vec1.x(), vec1.y(), vec1.z()).setColor(r, g, b, alpha).setUv(1.0f, (float)v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec2.x(), vec2.y(), vec2.z()).setColor(r, g, b, alpha).setUv(1.0f, (float)v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec3.x(), vec3.y(), vec3.z()).setColor(r, g, b, alpha).setUv(0.0f, (float)v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec4.x(), vec4.y(), vec4.z()).setColor(r, g, b, alpha).setUv(0.0f, (float)v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec4.x(), vec4.y(), vec4.z()).setColor(r, g, b, alpha).setUv(0.0f, (float)v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec3.x(), vec3.y(), vec3.z()).setColor(r, g, b, alpha).setUv(0.0f, (float)v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec2.x(), vec2.y(), vec2.z()).setColor(r, g, b, alpha).setUv(1.0f, (float)v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
            builder.addVertex(vec1.x(), vec1.y(), vec1.z()).setColor(r, g, b, alpha).setUv(1.0f, (float)v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
        }
    }
}

