/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.item;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.tile.LootFabTileEntity;
import dev.shadowsoffire.hostilenetworks.util.SavedSelections;
import dev.shadowsoffire.placebo.PlaceboClient;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.util.SpecialTooltipItem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.loading.FMLEnvironment;

public class FabDirectiveItem
extends Item
implements SpecialTooltipItem {
    public FabDirectiveItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        BlockEntity be = level.getBlockEntity(ctx.getClickedPos());
        if (be instanceof LootFabTileEntity) {
            LootFabTileEntity lootFab = (LootFabTileEntity)be;
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (player.isSecondaryUseActive()) {
                SavedSelections selections = (SavedSelections)ctx.getItemInHand().getOrDefault(Hostile.Components.FAB_SELECTIONS, (Object)SavedSelections.EMPTY);
                if (!selections.isEmpty()) {
                    lootFab.setSelections(selections.getSelections());
                    player.sendSystemMessage((Component)HostileNetworks.lang("text", "selections_applied", lootFab.getSelections().size(), ctx.getItemInHand().getDisplayName()).withColor(65472));
                    return InteractionResult.SUCCESS;
                }
            } else {
                Object2IntMap<DynamicHolder<DataModel>> fabSelections = lootFab.getSelections();
                SavedSelections selections = new SavedSelections(fabSelections);
                ctx.getItemInHand().set(Hostile.Components.FAB_SELECTIONS, (Object)selections);
                player.sendSystemMessage((Component)HostileNetworks.lang("text", "selections_copied", lootFab.getSelections().size(), lootFab.getBlockState().getBlock().getName()).withColor(65472));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.useOn(ctx);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        return super.use(level, player, usedHand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc2")).withStyle(ChatFormatting.GRAY));
        if (FMLEnvironment.dist.isClient()) {
            ClientAccess.appendHoverText(stack, context, list, flag);
        }
    }

    public static class ClientAccess {
        public static void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            SavedSelections selections = (SavedSelections)stack.getOrDefault(Hostile.Components.FAB_SELECTIONS, (Object)SavedSelections.EMPTY);
            if (selections.isEmpty()) {
                return;
            }
            list.add(CommonComponents.SPACE);
            Object2IntMap<DynamicHolder<DataModel>> fabSelections = selections.getSelections();
            int selIdx = PlaceboClient.getTooltipScrollIndex((int)selections.size());
            ObjectIterator it = fabSelections.object2IntEntrySet().iterator();
            it.skip(selIdx);
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            DynamicHolder holder = (DynamicHolder)entry.getKey();
            int index = entry.getIntValue();
            DataModel model = holder.isBound() ? (DataModel)holder.get() : null;
            ItemStack drop = model != null && index < model.fabDrops().size() ? model.fabDrops().get(index) : ItemStack.EMPTY;
            MutableComponent comp = HostileNetworks.lang("text", "stored_selection", selIdx + 1, selections.size()).withColor(65472);
            if (flag.hasShiftDown()) {
                comp.append(CommonComponents.SPACE);
                comp.append((Component)HostileNetworks.lang("text", "scroll", new Object[0]).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withUnderlined(Boolean.valueOf(false))));
            } else {
                comp.append(CommonComponents.SPACE);
                comp.append((Component)HostileNetworks.lang("text", "shift", new Object[0]).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withUnderlined(Boolean.valueOf(false))));
            }
            list.add((Component)comp);
            if (model != null) {
                if (!drop.isEmpty()) {
                    Component input = model.getPredictionDrop().getHoverName();
                    Component output = drop.getHoverName();
                    comp = HostileNetworks.lang("text", "selection", input, drop.getCount(), output).withColor(65472);
                    list.add((Component)comp);
                } else {
                    comp = HostileNetworks.lang("text", "invalid_selection.index", index).withStyle(ChatFormatting.RED);
                    list.add((Component)comp);
                }
            } else {
                comp = HostileNetworks.lang("text", "invalid_selection.model", holder.getId()).withStyle(ChatFormatting.RED);
                list.add((Component)comp);
            }
        }
    }
}

