/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.common.item.iface.mode;

import committee.nova.mods.avaritia.api.common.item.iface.mode.IModeChanger;
import committee.nova.mods.avaritia.api.common.item.iface.mode.IModeEnum;
import committee.nova.mods.avaritia.api.utils.text.ILangEntry;
import committee.nova.mods.avaritia.init.registry.enums.ModLang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface IItemMode<MODE extends Enum<MODE>>
extends IModeChanger<MODE> {
    public DataComponentType<MODE> getDataComponentType();

    public MODE getDefaultMode();

    @Override
    default public MODE getMode(@NotNull ItemStack stack) {
        return (MODE)((Enum)stack.getOrDefault(this.getDataComponentType(), this.getDefaultMode()));
    }

    @Override
    default public boolean changeMode(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        Object newMode;
        Object mode = this.getMode(stack);
        if (mode != (newMode = ((IModeEnum)mode).next(stack))) {
            stack.set(this.getDataComponentType(), newMode);
            player.displayClientMessage((Component)this.getModeSwitchEntry().translate(newMode), true);
            return true;
        }
        return false;
    }

    @Override
    default public boolean changeMode(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand, MODE newMode) {
        Object mode = this.getMode(stack);
        if (mode != newMode) {
            stack.set(this.getDataComponentType(), newMode);
            player.displayClientMessage((Component)this.getModeSwitchEntry().translate(newMode), true);
            return true;
        }
        return false;
    }

    default public ILangEntry getModeSwitchEntry() {
        return ModLang.MODE_SWITCH;
    }

    default public Component getToolTip(ItemStack stack) {
        return ModLang.CURRENT_MODE.translate(ChatFormatting.AQUA, this.getMode(stack));
    }
}

