/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.utils;

import committee.nova.mods.avaritia.api.common.container.FaceContainer;
import committee.nova.mods.avaritia.api.utils.ItemUtils;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ContainerUtils {
    @Nonnull
    public static ItemStack decrStackSize(Container inv, int slot, int size) {
        ItemStack item = inv.getItem(slot);
        if (!item.isEmpty()) {
            if (item.getCount() <= size) {
                inv.setItem(slot, ItemStack.EMPTY);
                inv.setChanged();
                return item;
            }
            ItemStack itemstack1 = item.split(size);
            if (item.getCount() == 0) {
                inv.setItem(slot, ItemStack.EMPTY);
            } else {
                inv.setItem(slot, item);
            }
            inv.setChanged();
            return itemstack1;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack removeStackFromSlot(Container inv, int slot) {
        ItemStack stack = inv.getItem(slot);
        inv.setItem(slot, ItemStack.EMPTY);
        return stack;
    }

    public static int incrStackSize(@Nonnull ItemStack base, @Nonnull ItemStack addition) {
        if (ContainerUtils.canStack(base, addition)) {
            return ContainerUtils.incrStackSize(base, addition.getCount());
        }
        return 0;
    }

    public static int incrStackSize(@Nonnull ItemStack base, int addition) {
        int totalSize = base.getCount() + addition;
        if (totalSize <= base.getMaxStackSize()) {
            return addition;
        }
        if (base.getCount() < base.getMaxStackSize()) {
            return base.getMaxStackSize() - base.getCount();
        }
        return 0;
    }

    public static boolean areStacksIdentical(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        if (stack1.isEmpty() || stack2.isEmpty()) {
            return stack1 == stack2;
        }
        return stack1.getItem() == stack2.getItem() && stack1.getDamageValue() == stack2.getDamageValue() && stack1.getCount() == stack2.getCount() && ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean canStack(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return stack1.isEmpty() || stack2.isEmpty() || stack1.getItem() == stack2.getItem() && stack2.getDamageValue() == stack1.getDamageValue() && ItemStack.isSameItemSameComponents((ItemStack)stack2, (ItemStack)stack1) && stack1.isStackable();
    }

    public static void consumeItem(Container inv, int slot) {
        ItemStack stack = inv.getItem(slot);
        Item item = stack.getItem();
        if (item.hasCraftingRemainingItem(stack)) {
            ItemStack container = item.getCraftingRemainingItem(stack);
            inv.setItem(slot, container);
        } else {
            inv.removeItem(slot, 1);
        }
    }

    public static int stackSize(Container inv, int slot) {
        ItemStack stack = inv.getItem(slot);
        return stack.isEmpty() ? 0 : stack.getCount();
    }

    public static void dropOnClose(Player player, Container inv) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.removeItemNoUpdate(i);
            if (stack.isEmpty()) continue;
            player.drop(stack, false);
        }
    }

    public static boolean canInsertStack(IItemHandler handler, int slot, ItemStack stack) {
        return handler.insertItem(slot, stack, true) != stack;
    }

    public static boolean canExtractStack(IItemHandler handler, int slot) {
        ItemStack stack = handler.getStackInSlot(slot);
        if (!stack.isEmpty()) {
            return !handler.extractItem(slot, stack.getMaxStackSize(), true).isEmpty();
        }
        return false;
    }

    public static ItemStack insertItem(IItemHandler handler, ItemStack insert, boolean simulate) {
        insert = insert.copy();
        for (int pass = 0; pass < 2; ++pass) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (pass == 0 && stack.isEmpty()) continue;
                if (insert.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                insert = handler.insertItem(slot, insert, simulate);
            }
        }
        return insert;
    }

    public static int fitStackInSlot(FaceContainer inv, int slot, ItemStack stack) {
        ItemStack base = inv.inv.getItem(slot);
        if (!ContainerUtils.canStack(base, stack) || !inv.canInsertItem(slot, stack)) {
            return 0;
        }
        int fit = !base.isEmpty() ? ContainerUtils.incrStackSize(base, inv.inv.getMaxStackSize() - base.getCount()) : inv.inv.getMaxStackSize();
        return Math.min(fit, stack.getCount());
    }

    public static int fitStackInSlot(Container inv, int slot, @Nonnull ItemStack stack) {
        return ContainerUtils.fitStackInSlot(new FaceContainer(inv), slot, stack);
    }

    public static int insertItem(FaceContainer inv, @Nonnull ItemStack stack, boolean simulate) {
        stack = stack.copy();
        for (int pass = 0; pass < 2; ++pass) {
            int[] nArray = inv.slots;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int fit;
                int slot;
                ItemStack base;
                if (pass == 0 == (base = inv.inv.getItem(slot = nArray[i])).isEmpty() || (fit = ContainerUtils.fitStackInSlot(inv, slot, stack)) == 0) continue;
                if (!base.isEmpty()) {
                    stack.shrink(fit);
                    if (!simulate) {
                        base.grow(fit);
                        inv.inv.setItem(slot, base);
                    }
                } else {
                    if (!simulate) {
                        inv.inv.setItem(slot, ItemUtils.copyStack(stack, fit));
                    }
                    stack.shrink(fit);
                }
                if (stack.getCount() != 0) continue;
                return 0;
            }
        }
        return stack.getCount();
    }

    public static int insertItem(Container inv, @Nonnull ItemStack stack, boolean simulate) {
        return ContainerUtils.insertItem(new FaceContainer(inv), stack, simulate);
    }

    public static int countMatchingStacks(IItemHandler handler, ItemStack filter, boolean insert) {
        int c = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.isEmpty() || !ItemUtils.areStacksSameType(filter, stack) || !(insert ? ContainerUtils.canInsertStack(handler, slot, stack) : ContainerUtils.canExtractStack(handler, slot))) continue;
            c += stack.getCount();
        }
        return c;
    }

    public static int getInsertableQuantity(IItemHandler handler, ItemStack stack) {
        ItemStack copy = ItemUtils.copyStack(stack, Integer.MAX_VALUE);
        int quantity = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            if (!ContainerUtils.canInsertStack(handler, slot, copy)) continue;
            ItemStack left = handler.insertItem(slot, copy, true);
            if (left.isEmpty()) {
                quantity += copy.getCount();
                continue;
            }
            quantity += copy.getCount() - left.getCount();
        }
        return quantity;
    }
}

