/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.utils;

import java.util.Arrays;
import java.util.Comparator;
import lombok.Generated;

public class DateUtils {
    public static String toMaxUnitString(double time, DateUnit curUnit) {
        return DateUtils.toMaxUnitString(time, curUnit, 0, 2);
    }

    public static String toMaxUnitString(double time, DateUnit curUnit, int decimalPlaces, int maxNineCount) {
        String formatPattern = "%." + decimalPlaces + "f";
        Object result = String.format(formatPattern, time) + curUnit.getUnit();
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        if (maxNineCount <= 0) {
            maxNineCount = 1;
        }
        if (String.valueOf((int)time).length() > maxNineCount) {
            int code = curUnit.getCode() + 1;
            if (code <= DateUnit.getMaxCode() && time > (double)curUnit.getBase()) {
                result = DateUtils.toMaxUnitString(time / (double)curUnit.getBase(), DateUnit.valueOf(code), decimalPlaces, maxNineCount);
            } else {
                int i;
                StringBuilder ninePart = new StringBuilder();
                StringBuilder decimal = new StringBuilder();
                for (i = 0; i < maxNineCount; ++i) {
                    ninePart.append("9");
                }
                for (i = 0; i < decimalPlaces; ++i) {
                    decimal.append("9");
                }
                result = decimalPlaces > 0 ? String.valueOf(ninePart) + "." + String.valueOf(decimal) + "+" + curUnit.getUnit() : String.valueOf(ninePart) + "+" + curUnit.getUnit();
            }
        }
        return result;
    }

    public static enum DateUnit {
        MILLISECOND(1, 1000, "ms"),
        SECOND(2, 60, "s"),
        MINUTE(3, 60, "m"),
        HOUR(4, 24, "h"),
        DAY(5, 30, "d");

        private final int code;
        private final int base;
        private final String unit;

        private DateUnit(int code, int base, String unit) {
            this.code = code;
            this.base = base;
            this.unit = unit;
        }

        public static DateUnit valueOf(int code) {
            for (DateUnit status : DateUnit.values()) {
                if (status.code != code) continue;
                return status;
            }
            throw new IllegalArgumentException("Invalid code: " + code);
        }

        public static int getMaxCode() {
            return Arrays.stream(DateUnit.values()).max(Comparator.comparingInt(DateUnit::getCode)).orElse(DateUnit.values()[DateUnit.values().length - 1]).getCode();
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public int getBase() {
            return this.base;
        }

        @Generated
        public String getUnit() {
            return this.unit;
        }
    }
}

