/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.utils.game;

import java.util.ArrayList;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class CraftingRecipeGridIndexGetter {
    private final ArrayList<Integer> indexArray = new ArrayList();
    private int last = 0;

    public CraftingRecipeGridIndexGetter(CraftingRecipe craftingRecipe) {
        if (craftingRecipe instanceof ShapedRecipe) {
            ShapedRecipe recipe = (ShapedRecipe)craftingRecipe;
            int x = 0;
            if (recipe.getWidth() == 1) {
                x = 1;
            }
            int y = recipe.getHeight() == 1 ? 1 : 3 - recipe.getHeight();
            for (int i = y; i < recipe.getHeight() + y; ++i) {
                for (int j = x; j < recipe.getWidth() + x; ++j) {
                    this.indexArray.add(i * 3 + j);
                }
            }
        } else if (craftingRecipe.getIngredients().size() == 1) {
            this.indexArray.add(4);
        } else {
            for (int i = 0; i < craftingRecipe.getIngredients().size(); ++i) {
                this.indexArray.add(i);
            }
        }
    }

    public int get() {
        if (this.last >= this.indexArray.size()) {
            return 8;
        }
        return this.indexArray.get(this.last++);
    }
}

