/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.utils.math;

import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public enum SortingType {
    NONE(null, null),
    NAME(Comparator.comparing(i -> i.getHoverName().getString()), (i1, i2) -> i2.getHoverName().getString().compareTo(i1.getHoverName().getString())),
    QUANTITY(Comparator.comparingInt(ItemStack::getCount).thenComparing(i -> i.getHoverName().getString()), (i1, i2) -> {
        int ret = Integer.compare(i2.getCount(), i1.getCount());
        if (ret == 0) {
            ret = i1.getHoverName().getString().compareTo(i2.getHoverName().getString());
        }
        return ret;
    }),
    ID(Comparator.comparingInt(i -> Item.getId((Item)i.getItem())).thenComparing(i -> i.getHoverName().getString()), (i1, i2) -> {
        int ret = Integer.compare(Item.getId((Item)i2.getItem()), Item.getId((Item)i1.getItem()));
        if (ret == 0) {
            ret = i1.getHoverName().getString().compareTo(i2.getHoverName().getString());
        }
        return ret;
    });

    private Comparator<ItemStack> comparatorAscending;
    private Comparator<ItemStack> comparatorDescending;

    private SortingType(Comparator<ItemStack> comparatorAscending, Comparator<ItemStack> comparatorDescending) {
        this.comparatorAscending = comparatorAscending;
        this.comparatorDescending = comparatorDescending;
    }

    public void sort(ArrayList<ItemStack> list, boolean ascending) {
        Comparator<ItemStack> comparator;
        Comparator<ItemStack> comparator2 = comparator = ascending ? this.comparatorAscending : this.comparatorDescending;
        if (comparator != null) {
            list.sort(comparator);
        }
    }

    public SortingType getNextType() {
        int ordinal = this.ordinal() + 1;
        if (ordinal >= SortingType.values().length) {
            ordinal = 0;
        }
        return SortingType.values()[ordinal];
    }
}

