/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client;

import committee.nova.mods.avaritia.api.iface.IFilterItem;
import committee.nova.mods.avaritia.client.screen.ItemFilterScreen;
import committee.nova.mods.avaritia.common.net.C2SElytraSpeedUpPacket;
import committee.nova.mods.avaritia.common.net.C2SOpenRingPack;
import committee.nova.mods.avaritia.init.config.ModConfig;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="avaritia", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class AvaritiaForgeClient {
    private static final String CATEGORIES = "key.avaritia.categories";
    public static final KeyMapping FILTER_KEY = new KeyMapping("key.avaritia.filter", 72, "key.avaritia.categories");
    public static final KeyMapping RING_KEY = new KeyMapping("key.avaritia.neutron_ring", 78, "key.avaritia.categories");
    public static final KeyMapping SORT_0 = new KeyMapping("key.avaritia.infinity_chest.sort0", 48, "key.avaritia.categories");
    public static final KeyMapping SORT_1 = new KeyMapping("key.avaritia.infinity_chest.sort1", 49, "key.avaritia.categories");
    public static final KeyMapping SORT_2 = new KeyMapping("key.avaritia.infinity_chest.sort2", 50, "key.avaritia.categories");
    public static final KeyMapping SORT_3 = new KeyMapping("key.avaritia.infinity_chest.sort3", 51, "key.avaritia.categories");
    public static final KeyMapping SORT_4 = new KeyMapping("key.avaritia.infinity_chest.sort4", 52, "key.avaritia.categories");
    public static final KeyMapping SORT_5 = new KeyMapping("key.avaritia.infinity_chest.sort5", 53, "key.avaritia.categories");
    public static final KeyMapping SORT_6 = new KeyMapping("key.avaritia.infinity_chest.sort6", 54, "key.avaritia.categories");
    public static final KeyMapping SORT_7 = new KeyMapping("key.avaritia.infinity_chest.sort7", 55, "key.avaritia.categories");
    public static final KeyMapping SORT_8 = new KeyMapping("key.avaritia.infinity_chest.sort8", 56, "key.avaritia.categories");
    public static final KeyMapping SORT_9 = new KeyMapping("key.avaritia.infinity_chest.sort9", 57, "key.avaritia.categories");
    private static int infinityElytraCooldown = 0;
    private static Component[] tooltipExt = new Component[0];

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        while (FILTER_KEY.consumeClick() && player != null) {
            if (player.getMainHandItem().isEmpty() || !(player.getMainHandItem().getItem() instanceof IFilterItem)) continue;
            Minecraft.getInstance().setScreen((Screen)new ItemFilterScreen());
        }
        while (RING_KEY.consumeClick() && player != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new C2SOpenRingPack(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        infinityElytraCooldown = Math.max(infinityElytraCooldown - 1, 0);
        if (Minecraft.getInstance().options.keyJump.isDown() && infinityElytraCooldown <= 0) {
            infinityElytraCooldown = 50;
            PacketDistributor.sendToServer((CustomPacketPayload)new C2SElytraSpeedUpPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void setTooltip(Component ... string) {
        tooltipExt = string;
    }

    @SubscribeEvent
    public static void getTooltip(ItemTooltipEvent evt) {
        Collections.addAll(evt.getToolTip(), tooltipExt);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemTooltip(ItemTooltipEvent e) {
        if (!FMLLoader.isProduction() || ((Boolean)ModConfig.useAdvanceTooltips.get()).booleanValue()) {
            ItemStack stack = e.getItemStack();
            List tooltips = e.getToolTip();
            if (Screen.hasAltDown()) {
                for (TypedDataComponent c : stack.getComponents()) {
                    Object object = c.value();
                    if (!(object instanceof CompoundTag)) continue;
                    CompoundTag tag = (CompoundTag)object;
                    AvaritiaForgeClient.addTagCompound("  ", tooltips, tag);
                }
            }
        }
    }

    private static void addTagCompound(String prefix, List<Component> list, CompoundTag tag) {
        TreeSet sortedKeys = new TreeSet(tag.getAllKeys());
        block9: for (String key : sortedKeys) {
            Tag elem = tag.get(key);
            switch (elem.getId()) {
                case 2: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u64022" + tag.getShort(key))));
                    break;
                }
                case 3: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u64023" + tag.getInt(key))));
                    break;
                }
                case 6: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u64026" + tag.getDouble(key))));
                    break;
                }
                case 8: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u64028" + tag.getString(key))));
                    break;
                }
                case 1: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u64029" + tag.getByte(key))));
                    break;
                }
                case 9: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u64029List, " + ((ListTag)elem).size() + " items")));
                    if (!Screen.hasShiftDown()) continue block9;
                    for (Tag key1 : (ListTag)elem) {
                        AvaritiaForgeClient.addTagCompound(prefix + "    ", list, (CompoundTag)key1);
                    }
                    continue block9;
                }
                case 10: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u6402aCompound")));
                    if (!Screen.hasShiftDown()) continue block9;
                    AvaritiaForgeClient.addTagCompound(prefix + "    ", list, (CompoundTag)elem);
                    break;
                }
                default: {
                    list.add((Component)Component.literal((String)(prefix + key + ": Type " + String.valueOf(elem.getType()))));
                }
            }
        }
    }
}

