/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import committee.nova.mods.avaritia.api.client.model.CachedFormat;
import committee.nova.mods.avaritia.api.client.model.PerspectiveModelState;
import committee.nova.mods.avaritia.api.client.model.Quad;
import committee.nova.mods.avaritia.api.client.model.bakedmodels.WrappedItemModel;
import committee.nova.mods.avaritia.api.client.render.buffer.AlphaOverrideVertexConsumer;
import committee.nova.mods.avaritia.api.client.util.TransformUtils;
import committee.nova.mods.avaritia.api.client.util.colour.ColourARGB;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class HaloBakedModel
extends WrappedItemModel {
    private final Random random = new Random();
    private final BakedQuad haloQuad;
    private final boolean pulse;

    public HaloBakedModel(BakedModel wrapped, TextureAtlasSprite sprite, int color, int size, boolean pulse) {
        super(wrapped);
        this.haloQuad = HaloBakedModel.generateHaloQuad(sprite, size, color);
        this.pulse = pulse;
    }

    static BakedQuad generateHaloQuad(TextureAtlasSprite sprite, int size, int color) {
        float[] colors = new ColourARGB(color).getRGBA();
        double spread = (double)size / 16.0;
        double min = 0.0 - spread;
        double max = 1.0 + spread;
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        Quad quad = new Quad();
        quad.reset(CachedFormat.BLOCK);
        quad.setTexture(sprite);
        HaloBakedModel.putVertex(quad.vertices[0], max, max, 0.0, maxU, minV);
        HaloBakedModel.putVertex(quad.vertices[1], min, max, 0.0, minU, minV);
        HaloBakedModel.putVertex(quad.vertices[2], min, min, 0.0, minU, maxV);
        HaloBakedModel.putVertex(quad.vertices[3], max, min, 0.0, maxU, maxV);
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(colors, 0, quad.vertices[i].color, 0, 4);
        }
        quad.calculateOrientation(true);
        return quad.bake();
    }

    static void putVertex(Quad.Vertex vx, double x, double y, double z, double u, double v) {
        vx.vec[0] = (float)x;
        vx.vec[1] = (float)y;
        vx.vec[2] = (float)z;
        vx.uv[0] = (float)u;
        vx.uv[1] = (float)v;
    }

    @Override
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack pStack, MultiBufferSource source, int packedLight, int packedOverlay) {
        if (transformType == ItemDisplayContext.GUI) {
            Minecraft.getInstance().getItemRenderer().renderQuadList(pStack, source.getBuffer(ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)true)), List.of(this.haloQuad), stack, packedLight, packedOverlay);
            if (this.pulse) {
                pStack.pushPose();
                double scale = this.random.nextDouble() * 0.15 + 0.95;
                double trans = (1.0 - scale) / 2.0;
                pStack.translate(trans, trans, 0.0);
                pStack.scale((float)scale, (float)scale, 1.0001f);
                this.renderWrapped(stack, pStack, source, packedLight, packedOverlay, true, e -> new AlphaOverrideVertexConsumer((VertexConsumer)e, 0.6f));
                pStack.popPose();
            }
        }
        this.renderWrapped(stack, pStack, source, packedLight, packedOverlay, true);
    }

    @Override
    public PerspectiveModelState getModelState() {
        return TransformUtils.DEFAULT_ITEM;
    }
}

