/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import committee.nova.mods.avaritia.api.client.model.CachedFormat;
import committee.nova.mods.avaritia.api.client.model.IVertexConsumer;
import committee.nova.mods.avaritia.api.client.model.Quad;
import committee.nova.mods.avaritia.client.model.HaloBakedModel;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.apache.commons.lang3.tuple.Pair;

public class HaloModelLoader
implements IGeometryLoader<HaloItemModelGeometry> {
    public static final HaloModelLoader INSTANCE = new HaloModelLoader();

    public HaloItemModelGeometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
        JsonObject halo = modelContents.getAsJsonObject("halo");
        if (halo == null) {
            throw new IllegalStateException("Missing 'halo' object.");
        }
        IntArrayList layerColors = new IntArrayList();
        JsonArray layerColorsArr = modelContents.getAsJsonArray("layerColors");
        if (layerColorsArr != null) {
            for (JsonElement jsonElement : layerColorsArr) {
                layerColors.add(jsonElement.getAsInt());
            }
        }
        String texture = GsonHelper.getAsString((JsonObject)halo, (String)"texture");
        int color = GsonHelper.getAsInt((JsonObject)halo, (String)"color");
        int size = GsonHelper.getAsInt((JsonObject)halo, (String)"size");
        boolean pulse = GsonHelper.getAsBoolean((JsonObject)halo, (String)"pulse");
        JsonObject clean = modelContents.getAsJsonObject();
        clean.remove("halo");
        clean.remove("loader");
        BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)clean, BlockModel.class);
        return new HaloItemModelGeometry(baseModel, (IntList)layerColors, texture, color, size, pulse);
    }

    public static class HaloItemModelGeometry
    implements IUnbakedGeometry<HaloItemModelGeometry> {
        private static final ConcurrentMap<Pair<VertexFormat, VertexFormat>, int[]> formatMaps = new ConcurrentHashMap<Pair<VertexFormat, VertexFormat>, int[]>();
        private static final int[] DEFAULT_MAPPING = HaloItemModelGeometry.generateMapping(DefaultVertexFormat.BLOCK, DefaultVertexFormat.BLOCK);
        private final BlockModel baseModel;
        private final IntList layerColors;
        private final String texture;
        private final int color;
        private final int size;
        private final boolean pulse;

        public HaloItemModelGeometry(BlockModel baseModel, IntList layerColors, String texture, int color, int size, boolean pulse) {
            this.baseModel = baseModel;
            this.layerColors = layerColors;
            this.texture = texture;
            this.color = color;
            this.size = size;
            this.pulse = pulse;
        }

        private static BakedModel tintLayers(BakedModel model, IntList layerColors) {
            if (layerColors.isEmpty()) {
                return model;
            }
            HashMap<Direction, List<BakedQuad>> faceQuads = new HashMap<Direction, List<BakedQuad>>();
            for (Direction face : Direction.values()) {
                faceQuads.put(face, HaloItemModelGeometry.transformQuads(model.getQuads(null, face, RandomSource.create()), layerColors));
            }
            List<BakedQuad> unculled = HaloItemModelGeometry.transformQuads(model.getQuads(null, null, RandomSource.create()), layerColors);
            return new SimpleBakedModel(unculled, faceQuads, model.useAmbientOcclusion(), model.usesBlockLight(), model.isGui3d(), model.getParticleIcon(), model.getTransforms(), ItemOverrides.EMPTY, RenderTypeGroup.EMPTY);
        }

        static List<BakedQuad> transformQuads(List<BakedQuad> quads, IntList layerColors) {
            ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(quads.size());
            for (BakedQuad quad : quads) {
                newQuads.add(HaloItemModelGeometry.transformQuad(quad, layerColors));
            }
            return newQuads;
        }

        public static int[] mapFormats(VertexFormat from, VertexFormat to) {
            if (from.equals((Object)DefaultVertexFormat.BLOCK) && to.equals((Object)DefaultVertexFormat.BLOCK)) {
                return DEFAULT_MAPPING;
            }
            return formatMaps.computeIfAbsent((Pair<VertexFormat, VertexFormat>)Pair.of((Object)from, (Object)to), pair -> HaloItemModelGeometry.generateMapping((VertexFormat)pair.getLeft(), (VertexFormat)pair.getRight()));
        }

        public static void unpack(int[] from, float[] to, VertexFormat formatFrom, int v, int e) {
            int length = Math.min(4, to.length);
            VertexFormatElement element = (VertexFormatElement)formatFrom.getElements().get(e);
            int vertexStart = v * formatFrom.getVertexSize() + formatFrom.getOffset(VertexFormatElement.byId((int)e));
            int count = element.count();
            VertexFormatElement.Type type = element.type();
            VertexFormatElement.Usage usage = element.usage();
            int size = type.size();
            int mask = (256 << 8 * (size - 1)) - 1;
            for (int i = 0; i < length; ++i) {
                if (i < count) {
                    int pos = vertexStart + size * i;
                    int index = pos >> 2;
                    int offset = pos & 3;
                    int bits = from[index];
                    bits >>>= offset * 8;
                    if ((pos + size - 1) / 4 != index) {
                        bits |= from[index + 1] << (4 - offset) * 8;
                    }
                    bits &= mask;
                    if (type == VertexFormatElement.Type.FLOAT) {
                        to[i] = Float.intBitsToFloat(bits);
                        continue;
                    }
                    if (type == VertexFormatElement.Type.UBYTE || type == VertexFormatElement.Type.USHORT) {
                        to[i] = (float)bits / (float)mask;
                        continue;
                    }
                    if (type == VertexFormatElement.Type.UINT) {
                        to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                        continue;
                    }
                    if (type == VertexFormatElement.Type.BYTE) {
                        to[i] = (float)((byte)bits) / (float)(mask >> 1);
                        continue;
                    }
                    if (type == VertexFormatElement.Type.SHORT) {
                        to[i] = (float)((short)bits) / (float)(mask >> 1);
                        continue;
                    }
                    if (type != VertexFormatElement.Type.INT) continue;
                    to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 2.147483647E9);
                    continue;
                }
                to[i] = i == 3 && usage == VertexFormatElement.Usage.POSITION ? 1.0f : 0.0f;
            }
        }

        private static int[] generateMapping(VertexFormat from, VertexFormat to) {
            int fromCount = from.getElements().size();
            int toCount = to.getElements().size();
            int[] eMap = new int[fromCount];
            for (int e = 0; e < fromCount; ++e) {
                int e2;
                VertexFormatElement expected = (VertexFormatElement)from.getElements().get(e);
                for (e2 = 0; e2 < toCount; ++e2) {
                    VertexFormatElement current = (VertexFormatElement)to.getElements().get(e2);
                    if (expected.usage() == current.usage() && expected.index() == current.index()) break;
                }
                eMap[e] = e2;
            }
            return eMap;
        }

        public static void putBakedQuad(IVertexConsumer consumer, BakedQuad quad) {
            consumer.setTexture(quad.getSprite());
            consumer.setQuadOrientation(quad.getDirection());
            if (quad.isTinted()) {
                consumer.setQuadTint(quad.getTintIndex());
            }
            consumer.setApplyDiffuseLighting(quad.isShade());
            float[] data = new float[4];
            VertexFormat formatFrom = consumer.getVertexFormat();
            VertexFormat formatTo = DefaultVertexFormat.BLOCK;
            int countFrom = formatFrom.getElements().size();
            int countTo = formatTo.getElements().size();
            int[] eMap = HaloItemModelGeometry.mapFormats(formatFrom, formatTo);
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < countFrom; ++e) {
                    if (eMap[e] != countTo) {
                        HaloItemModelGeometry.unpack(quad.getVertices(), data, formatTo, v, eMap[e]);
                        consumer.put(e, data);
                        continue;
                    }
                    consumer.put(e, new float[0]);
                }
            }
        }

        static BakedQuad transformQuad(BakedQuad quad, IntList layerColors) {
            int tintIndex = quad.getTintIndex();
            if (tintIndex == -1 || tintIndex >= layerColors.size()) {
                return quad;
            }
            int tint = layerColors.getInt(tintIndex);
            if (tint == -1) {
                return quad;
            }
            Quad newQuad = new Quad();
            newQuad.reset(CachedFormat.BLOCK);
            HaloItemModelGeometry.putBakedQuad(newQuad, quad);
            float r = (float)(tint >> 16 & 0xFF) / 255.0f;
            float g = (float)(tint >> 8 & 0xFF) / 255.0f;
            float b = (float)(tint & 0xFF) / 255.0f;
            for (Quad.Vertex v : newQuad.vertices) {
                v.color[0] = v.color[0] * r;
                v.color[1] = v.color[1] * g;
                v.color[2] = v.color[2] * b;
            }
            newQuad.tintIndex = -1;
            return newQuad.bake();
        }

        public BakedModel bake(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides) {
            BakedModel bakedBaseModel = this.baseModel.bake(bakery, this.baseModel, spriteGetter, modelTransform, false);
            Material particleLocation = this.baseModel.getMaterial(this.texture);
            TextureAtlasSprite particle = spriteGetter.apply(particleLocation);
            return new HaloBakedModel(HaloItemModelGeometry.tintLayers(bakedBaseModel, this.layerColors), particle, this.color, this.size, this.pulse);
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.baseModel.resolveParents(modelGetter);
        }
    }
}

