/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.entity;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.common.entity.BladeSlashEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BladeSlashRender
extends EntityRenderer<BladeSlashEntity> {
    private static final RenderType RENDER_TYPE = RenderType.create((String)"blade_projectile", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(Res.BLADE_SLASH, false, false)).setShaderState(RenderStateShard.RENDERTYPE_TEXT_SEE_THROUGH_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).createCompositeState(true));

    public BladeSlashRender(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(BladeSlashEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource buffer, int packedLight) {
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot()) + 10.0f));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(entity.zRot));
        matrixStackIn.scale(0.6f, 0.6f, 1.8f);
        PoseStack.Pose matrixStackEntry = matrixStackIn.last();
        VertexConsumer builder = buffer.getBuffer(RENDER_TYPE);
        packedLight = 0xF000F0;
        this.vertex(matrixStackEntry, builder, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0, 1, 0, packedLight);
        this.vertex(matrixStackEntry, builder, 1.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0, 1, 0, packedLight);
        this.vertex(matrixStackEntry, builder, -1.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0, 1, 0, packedLight);
        this.vertex(matrixStackEntry, builder, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0, 1, 0, packedLight);
        matrixStackIn.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, matrixStackIn, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BladeSlashEntity entity) {
        return Res.BLADE_SLASH;
    }

    public void vertex(PoseStack.Pose pose, VertexConsumer builder, float x, float y, float z, float u, float v, int nx, int nz, int ny, int packedLight) {
        builder.addVertex(x, y, z).setColor(255, 255, 255, 200).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal((float)nx, (float)ny, (float)nz);
    }
}

