/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.common.menu.ExtremeAnvilMenu;
import committee.nova.mods.avaritia.common.net.C2SRenamePack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ExtremeAnvilScreen
extends BaseContainerScreen<ExtremeAnvilMenu> {
    private static final ResourceLocation ANVIL_LOCATION = Const.rl("textures/gui/extreme_anvil_gui.png");
    private EditBox name;

    public ExtremeAnvilScreen(ExtremeAnvilMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle, ANVIL_LOCATION);
        this.titleLabelX = 60;
    }

    @Override
    protected void subInit() {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.name = new EditBox(this.font, i + 62, j + 28, 103, 12, (Component)Component.translatable((String)"container.repair"));
        this.name.setCanLoseFocus(false);
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setBordered(false);
        this.name.setMaxLength(50);
        this.name.setResponder(this::onNameChanged);
        this.name.setValue("");
        this.addWidget((GuiEventListener)this.name);
        this.setInitialFocus((GuiEventListener)this.name);
        this.name.setEditable(false);
    }

    public void resize(@NotNull Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.name.getValue();
        this.init(pMinecraft, pWidth, pHeight);
        this.name.setValue(s);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return this.name.keyPressed(pKeyCode, pScanCode, pModifiers) || this.name.canConsumeInput() || super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    private void onNameChanged(String name) {
        Slot slot = ((ExtremeAnvilMenu)this.menu).getSlot(0);
        if (slot.hasItem()) {
            String s = name;
            if (name.equals(slot.getItem().getHoverName().getString())) {
                s = "";
            }
            if (((ExtremeAnvilMenu)this.menu).setItemName(s)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new C2SRenamePack(s), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    protected void renderBg(@NotNull GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        super.renderBg(pGuiGraphics, pPartialTick, pMouseX, pMouseY);
        pGuiGraphics.blit(ANVIL_LOCATION, this.leftPos + 59, this.topPos + 23, 0, this.imageHeight + (((ExtremeAnvilMenu)this.menu).getSlot(0).hasItem() ? 0 : 16), 110, 16);
    }

    @Override
    public void renderFg(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.name.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    protected void renderBgOthers(@NotNull GuiGraphics pGuiGraphics, int pX, int pY) {
        if ((((ExtremeAnvilMenu)this.menu).getSlot(0).hasItem() || ((ExtremeAnvilMenu)this.menu).getSlot(1).hasItem()) && !((ExtremeAnvilMenu)this.menu).getSlot(((ExtremeAnvilMenu)this.menu).getResultSlot()).hasItem()) {
            pGuiGraphics.blit(ANVIL_LOCATION, pX + 99, pY + 47, this.imageWidth, 0, 28, 21);
        }
    }

    @Override
    public void slotChanged(@NotNull AbstractContainerMenu pContainerToSend, int pSlotInd, @NotNull ItemStack pStack) {
        if (pSlotInd == 0) {
            this.name.setValue(pStack.isEmpty() ? "" : pStack.getHoverName().getString());
            this.name.setEditable(!pStack.isEmpty());
            this.setFocused((GuiEventListener)this.name);
        }
    }
}

