/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.client.AvaritiaForgeClient;
import committee.nova.mods.avaritia.common.menu.InfinityChestMenu;
import committee.nova.mods.avaritia.init.config.ModConfig;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public class InfinityChestScreen
extends BaseContainerScreen<InfinityChestMenu> {
    private static final KeyMapping[] SORT_KEYS = new KeyMapping[]{AvaritiaForgeClient.SORT_0, AvaritiaForgeClient.SORT_1, AvaritiaForgeClient.SORT_2, AvaritiaForgeClient.SORT_3, AvaritiaForgeClient.SORT_4, AvaritiaForgeClient.SORT_5, AvaritiaForgeClient.SORT_6, AvaritiaForgeClient.SORT_7, AvaritiaForgeClient.SORT_8, AvaritiaForgeClient.SORT_9};
    private static final ResourceLocation MULTI_PAGE_TEXTURE = Const.rl("textures/gui/infinity_chest.png");
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat(",###");
    private final int inventoryRows = (Integer)ModConfig.inventoryRows.get();

    public InfinityChestScreen(InfinityChestMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, MULTI_PAGE_TEXTURE);
        this.imageHeight = 132 + this.inventoryRows * 18;
        this.inventoryLabelY = this.imageHeight - 93;
    }

    protected void containerTick() {
        super.containerTick();
    }

    @Override
    protected void subInit() {
    }

    @Override
    protected void renderBgOthers(GuiGraphics pGuiGraphics, int pX, int pY) {
        Slot slot;
        pGuiGraphics.blit(MULTI_PAGE_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.inventoryRows * 18 + 35);
        pGuiGraphics.blit(MULTI_PAGE_TEXTURE, this.leftPos, this.topPos + this.inventoryRows * 18 + 35, 0, 143, this.imageWidth, 97);
        int index = ((InfinityChestMenu)this.menu).getSwapIndex();
        Slot slot2 = slot = index >= 0 && index < ((InfinityChestMenu)this.menu).slots.size() ? ((InfinityChestMenu)this.menu).getSlot(index) : null;
        if (slot != null && Objects.equals(slot.container, ((InfinityChestMenu)this.menu).getChestContainer())) {
            RenderSystem.disableDepthTest();
            int xPos = this.leftPos + slot.x;
            int yPos = this.topPos + slot.y;
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            pGuiGraphics.fillGradient(xPos, yPos, xPos + 16, yPos + 16, -2130771968, -2130771968);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    protected void renderLabels(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        super.renderLabels(pGuiGraphics, pMouseX, pMouseY);
        String page = ((InfinityChestMenu)this.menu).getCurrentPage() + 1 + " / ";
        int pageWidth = this.font.width(page);
        pGuiGraphics.drawString(this.font, page, 149 - pageWidth, 24, 0x404040, false);
        pGuiGraphics.drawString(this.font, "\u922d\ufffd", 149, 24, 0x404040, false);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (Stream.of(SORT_KEYS).anyMatch(key -> key.matches(pKeyCode, pScanCode))) {
            for (int i = 0; i < SORT_KEYS.length; ++i) {
                if (!SORT_KEYS[i].matches(pKeyCode, pScanCode)) continue;
                super.slotClicked(null, 0, i, ClickType.CLONE);
                return true;
            }
            return false;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    protected void renderFg(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderSlotCount(pGuiGraphics);
    }

    public void renderSlotCount(GuiGraphics pGuiGraphics) {
        PoseStack poseStack = pGuiGraphics.pose();
        for (int i = 0; i < ((InfinityChestMenu)this.menu).slots.size(); ++i) {
            long count = ((InfinityChestMenu)this.menu).getItemCount(i);
            float fontSize = 0.5f;
            if (count == 0L) continue;
            Object stringCount = String.valueOf(count);
            if (count > 1000L) {
                stringCount = DECIMAL_FORMAT.format(count);
                if (((String)(stringCount = ((String)stringCount).substring(0, 4))).endsWith(",")) {
                    stringCount = ((String)stringCount).substring(0, 3);
                }
                stringCount = ((String)stringCount).replace(",", ".");
                stringCount = count < 1000000L ? (String)stringCount + "K" : (count < 1000000000L ? (String)stringCount + "M" : (count < 1000000000000L ? (String)stringCount + "G" : (count < 1000000000000000L ? (String)stringCount + "T" : (count < 1000000000000000000L ? (String)stringCount + "P" : (String)stringCount + "E"))));
            }
            RenderSystem.enableDepthTest();
            poseStack.pushPose();
            poseStack.translate((double)(this.leftPos + ((InfinityChestMenu)this.menu).getSlot((int)i).x), (double)(this.topPos + ((InfinityChestMenu)this.menu).getSlot((int)i).y), 300.0);
            poseStack.scale(fontSize, fontSize, 1.0f);
            int n = (int)((16.0f - (float)this.font.width((String)stringCount) * fontSize) / fontSize);
            Objects.requireNonNull(this.font);
            pGuiGraphics.drawString(this.font, (String)stringCount, n, (int)((16.0f - 9.0f * fontSize) / fontSize), 0xFFFFFF);
            poseStack.popPose();
        }
    }

    protected void slotClicked(@Nullable Slot slotIn, int slotId, int mouseButton, @NotNull ClickType type) {
        if (type == ClickType.CLONE) {
            super.slotClicked(null, slotId, 1, type);
        } else {
            if (slotIn != null) {
                if (type == ClickType.PICKUP) {
                    if (InfinityChestScreen.hasAltDown()) {
                        if (Objects.equals(slotIn.container, ((InfinityChestMenu)this.menu).getChestContainer())) {
                            super.slotClicked(slotIn, slotId, 2, type);
                            return;
                        }
                    } else if (InfinityChestScreen.hasControlDown() && (Objects.equals(slotIn.container, ((InfinityChestMenu)this.menu).getChestContainer()) || Objects.equals(slotIn.container, ((InfinityChestMenu)this.menu).getPlayerInventory()))) {
                        super.slotClicked(slotIn, slotId, 3, type);
                        return;
                    }
                } else if (type == ClickType.QUICK_MOVE && (Objects.equals(slotIn.container, ((InfinityChestMenu)this.menu).getChestContainer()) || Objects.equals(slotIn.container, ((InfinityChestMenu)this.menu).getPlayerInventory())) && InfinityChestScreen.hasControlDown()) {
                    super.slotClicked(slotIn, slotId, 2, type);
                    return;
                }
            }
            if (slotIn != null) {
                super.slotClicked(slotIn, slotId, mouseButton, type);
            }
        }
    }
}

