/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.mojang.serialization.MapCodec;
import committee.nova.mods.avaritia.api.common.crafting.TierInput;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import committee.nova.mods.avaritia.init.handler.SingularityRegistryHandler;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.util.SingularityUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EternalSingularityCraftRecipe
extends ShapelessTableCraftingRecipe {
    private static final Object2BooleanOpenHashMap<EternalSingularityCraftRecipe> INGREDIENTS_LOADED = new Object2BooleanOpenHashMap();
    public NonNullList<Ingredient> inputs = NonNullList.create();

    public EternalSingularityCraftRecipe(ItemStack output) {
        super((NonNullList<Ingredient>)NonNullList.create(), output, 4);
    }

    public static void invalidate() {
        INGREDIENTS_LOADED.clear();
    }

    @Override
    public boolean matches(@NotNull TierInput input, @NotNull Level level) {
        NonNullList<Ingredient> ingredients = this.getIngredients();
        return !ingredients.isEmpty() && super.matches(input, level);
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        if (!INGREDIENTS_LOADED.getOrDefault((Object)this, false)) {
            super.getIngredients().clear();
            SingularityRegistryHandler.getInstance().getSingularities().stream().filter(singularity -> singularity.getIngredient() != Ingredient.EMPTY).limit(81L).map(SingularityUtils::getItemForSingularity).map(xva$0 -> Ingredient.of((ItemStack[])new ItemStack[]{xva$0})).forEach(arg_0 -> super.getIngredients().add(arg_0));
            INGREDIENTS_LOADED.put((Object)this, true);
        }
        return super.getIngredients();
    }

    @Override
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.ETERNAL_SINGULARITY_CRAFT_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<EternalSingularityCraftRecipe> {
        public static final MapCodec<EternalSingularityCraftRecipe> CODEC = MapCodec.unit(() -> new EternalSingularityCraftRecipe(new ItemStack((ItemLike)ModItems.eternal_singularity.get())));
        public static final StreamCodec<RegistryFriendlyByteBuf, EternalSingularityCraftRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<EternalSingularityCraftRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, EternalSingularityCraftRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static EternalSingularityCraftRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new EternalSingularityCraftRecipe(new ItemStack((ItemLike)ModItems.eternal_singularity.get()));
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, EternalSingularityCraftRecipe recipe) {
        }
    }
}

