/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import committee.nova.mods.avaritia.api.common.crafting.ITierCraftingRecipe;
import committee.nova.mods.avaritia.api.common.crafting.TierInput;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.NotNull;

public class ShapelessTableCraftingRecipe
implements ITierCraftingRecipe {
    private final NonNullList<Ingredient> inputs;
    private final ItemStack result;
    private final int tier;
    private BiFunction<Integer, ItemStack, ItemStack> transformer;

    public ShapelessTableCraftingRecipe(NonNullList<Ingredient> inputs, ItemStack result) {
        this(inputs, result, 0);
    }

    public ShapelessTableCraftingRecipe(NonNullList<Ingredient> inputs, ItemStack result, int tier) {
        this.inputs = inputs;
        this.result = result;
        this.tier = tier;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result;
    }

    public boolean matches(@NotNull TierInput input, @NotNull Level level) {
        if (this.tier != 0 && this.tier != input.tier()) {
            return false;
        }
        if (this.inputs.size() != input.ingredientCount()) {
            return false;
        }
        NonNullList inputs = NonNullList.create();
        for (int i = 0; i < input.size(); ++i) {
            ItemStack item = input.getItem(i);
            if (item.isEmpty()) continue;
            inputs.add((Object)item);
        }
        return RecipeMatcher.findMatches((List)inputs, this.inputs) != null;
    }

    @NotNull
    public ItemStack assemble(@NotNull TierInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPELESS_CRAFT_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.inputs.size();
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(TierInput inventory) {
        NonNullList remaining = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (!item.hasCraftingRemainingItem()) continue;
            remaining.set(i, (Object)item.getCraftingRemainingItem());
        }
        if (this.transformer != null) {
            boolean[] used = new boolean[remaining.size()];
            block1: for (int i = 0; i < remaining.size(); ++i) {
                ItemStack stack = inventory.getItem(i);
                for (int j = 0; j < this.inputs.size(); ++j) {
                    Ingredient input = (Ingredient)this.inputs.get(j);
                    if (used[j] || !input.test(stack)) continue;
                    ItemStack ingredient = this.transformer.apply(j, stack);
                    used[j] = true;
                    remaining.set(i, (Object)ingredient);
                    continue block1;
                }
            }
        }
        return remaining;
    }

    @Override
    public int getTier() {
        if (this.tier > 0) {
            return this.tier;
        }
        int size = this.inputs.size();
        return size < 10 ? 1 : (size < 26 ? 2 : (size < 50 ? 3 : 4));
    }

    @Override
    public boolean hasRequiredTier() {
        return this.tier > 0;
    }

    public void setTransformers(BiFunction<Integer, ItemStack, ItemStack> transformer) {
        this.transformer = transformer;
    }

    @Generated
    public NonNullList<Ingredient> getInputs() {
        return this.inputs;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessTableCraftingRecipe> {
        public static final MapCodec<ShapelessTableCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(field -> {
            int max = 81;
            Object[] ingredients = (Ingredient[])field.toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for Combination recipe");
            }
            return ingredients.length > max ? DataResult.error(() -> "Too many ingredients for Combination recipe. The maximum is: %s".formatted(max)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(recipe -> recipe.inputs), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.optionalFieldOf("tier", (Object)0).forGetter(recipe -> recipe.tier)).apply((Applicative)builder, ShapelessTableCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessTableCraftingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<ShapelessTableCraftingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ShapelessTableCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapelessTableCraftingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int size = buffer.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int tier = buffer.readVarInt();
            return new ShapelessTableCraftingRecipe((NonNullList<Ingredient>)inputs, result, tier);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ShapelessTableCraftingRecipe recipe) {
            buffer.writeVarInt(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeVarInt(recipe.tier);
        }
    }
}

