/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity;

import committee.nova.mods.avaritia.api.utils.EntityUtils;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class BladeSlashEntity
extends Projectile {
    public static float defaultSpeed = 2.0f;
    public final float zRot;
    public float damage = ((Integer)ModConfig.bladeSlashDamage.get()).intValue();
    public int duration = (Integer)ModConfig.bladeSlashRadius.get();

    public BladeSlashEntity(EntityType<? extends Projectile> type, Level worldIn) {
        super(type, worldIn);
        this.zRot = (worldIn.getRandom().nextFloat() - 0.5f) * 50.0f;
    }

    public BladeSlashEntity(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends Projectile>)((EntityType)ModEntities.BLADE_SLASH.get()), worldIn);
        this.setPos(x, y, z);
    }

    public BladeSlashEntity(Level worldIn, LivingEntity livingEntityIn) {
        this(worldIn, livingEntityIn.getX(), 0.7 * livingEntityIn.getEyeY() + 0.3 * livingEntityIn.getY(), livingEntityIn.getZ());
        this.setOwner((Entity)livingEntityIn);
        this.shootFromRotation((Entity)livingEntityIn, livingEntityIn.getXRot(), livingEntityIn.getYRot(), 0.0f, defaultSpeed, 0.5f);
    }

    public BladeSlashEntity(Level worldIn, LivingEntity livingEntityIn, int damageModifier) {
        this(worldIn, livingEntityIn);
        this.damage += (float)damageModifier;
    }

    public BladeSlashEntity(Level worldIn, LivingEntity livingEntityIn, int damageModifier, int durationModifier) {
        this(worldIn, livingEntityIn, damageModifier);
        this.duration += durationModifier;
    }

    protected void doWaterSplashEffect() {
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.level().damageSources().fellOutOfWorld(), this.damage);
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.tickCount > this.duration) {
            this.discard();
        }
        this.calculateCollision(this.level());
        this.checkInsideBlocks();
        Vec3 velocity = this.getDeltaMovement();
        this.setPos(this.getX() + velocity.x, this.getY() + velocity.y, this.getZ() + velocity.z);
    }

    public boolean shouldRenderAtSqrDistance(double p_70112_1_) {
        double d0 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_70112_1_ < (d0 = d0 * 64.0 * BladeSlashEntity.getViewScale()) * d0;
    }

    protected void calculateCollision(Level world) {
        Vec3 start = this.position();
        Vec3 end = start.add(this.getDeltaMovement());
        BlockHitResult blockResult = this.getBlockHitResult(world, start, end);
        boolean blockCollision = false;
        if (blockResult.getType() != HitResult.Type.MISS) {
            end = blockResult.getLocation();
            blockCollision = true;
        }
        this.hitEntities(this.level(), start, end);
        if (blockCollision && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)blockResult)) {
            this.onHitBlock(blockResult);
        }
    }

    protected BlockHitResult getBlockHitResult(Level world, Vec3 startPos, Vec3 endPos) {
        return world.clip(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
    }

    protected void hitEntities(Level world, Vec3 startPos, Vec3 endPos) {
        EntityUtils.findHitEntities(world, this, startPos, endPos, x$0 -> this.canHitEntity((Entity)x$0)).filter(result -> !EventHooks.onProjectileImpact((Projectile)this, (HitResult)result)).forEach(this::onHitEntity);
    }
}

