/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity;

import committee.nova.mods.avaritia.api.utils.PlayerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class FireBallEntity
extends ThrowableProjectile {
    public FireBallEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void onHit(@NotNull HitResult result) {
        super.onHit(result);
        this.discard();
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        Entity owner;
        super.onHitBlock(result);
        if (!this.level().isClientSide && (owner = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)owner;
            BlockPos pos = result.getBlockPos();
            BlockState state = this.level().getBlockState(pos);
            if (state.is(Blocks.OBSIDIAN)) {
                this.level().setBlockAndUpdate(pos, Blocks.LAVA.defaultBlockState());
            } else if (state.is(Blocks.SAND)) {
                BlockPos.betweenClosedStream((BlockPos)pos.offset(-2, -2, -2), (BlockPos)pos.offset(2, 2, 2)).forEach(currentPos -> {
                    if (this.level().getBlockState(currentPos).is(Blocks.SAND)) {
                        PlayerUtils.checkedPlaceBlock(player, pos.immutable(), Blocks.GLASS.defaultBlockState());
                    }
                });
            } else {
                BlockPos.betweenClosedStream((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1)).forEach(currentPos -> {
                    if (this.level().isEmptyBlock(currentPos)) {
                        PlayerUtils.checkedPlaceBlock(player, currentPos.immutable(), Blocks.FIRE.defaultBlockState());
                    }
                });
            }
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Entity owner;
        super.onHitEntity(result);
        if (!this.level().isClientSide && (owner = this.getOwner()) instanceof Player) {
            Entity ent = result.getEntity();
            ent.setRemainingFireTicks(100);
            ent.hurt(this.level().damageSources().inFire(), 50.0f);
        }
    }

    public boolean ignoreExplosion(@NotNull Explosion explosion) {
        return true;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }
}

