/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.misc;

import committee.nova.mods.avaritia.api.common.item.iface.IItemCapability;
import committee.nova.mods.avaritia.common.item.resources.ResourceItem;
import committee.nova.mods.avaritia.common.wrappers.InfinityBucketWrapper;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityBucketItem
extends ResourceItem
implements IItemCapability {
    public static final String FLUIDS_NBT = "Fluids";
    public static final String FLUID_ID_KEY = "Id";
    public static final String FLUID_AMOUNT_KEY = "Amount";

    public InfinityBucketItem() {
        super((Rarity)ModRarities.LEGEND.getValue(), "infinity_bucket", true, new Item.Properties().stacksTo(1));
    }

    public static List<FluidStack> getFluids(ItemStack stack) {
        CompoundTag nbt = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).isEmpty()) {
            return new ArrayList<FluidStack>();
        }
        if (!nbt.contains(FLUIDS_NBT, 9)) {
            return new ArrayList<FluidStack>();
        }
        return nbt.getList(FLUIDS_NBT, 10).stream().filter(tag -> tag.getId() == 10).map(tag -> InfinityBucketItem.loadFluidStackFromNBT((CompoundTag)tag)).collect(Collectors.toList());
    }

    public static void setFluids(ItemStack stack, List<FluidStack> fluids) {
        ListTag listTag = new ListTag();
        for (FluidStack fluid : fluids) {
            listTag.add((Object)InfinityBucketItem.writeFluidStackToNBT(fluid, new CompoundTag()));
        }
        CompoundTag tag = new CompoundTag();
        tag.put(FLUIDS_NBT, (Tag)listTag);
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, nbt -> nbt.update(tag1 -> tag1.merge(tag)));
    }

    @NotNull
    public static FluidStack loadFluidStackFromNBT(CompoundTag nbt) {
        if (nbt == null) {
            return FluidStack.EMPTY;
        }
        if (!nbt.contains(FLUID_ID_KEY, 8)) {
            return FluidStack.EMPTY;
        }
        ResourceLocation fluidName = ResourceLocation.parse((String)nbt.getString(FLUID_ID_KEY));
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluidName);
        int amount = nbt.getInt(FLUID_AMOUNT_KEY);
        return new FluidStack(fluid, amount);
    }

    @NotNull
    public static CompoundTag writeFluidStackToNBT(FluidStack fluidStack, CompoundTag nbt) {
        nbt.putString(FLUID_ID_KEY, InfinityBucketItem.getFluidName(fluidStack));
        nbt.putInt(FLUID_AMOUNT_KEY, fluidStack.getAmount());
        return nbt;
    }

    @NotNull
    public static String getFluidName(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation fluidName = BuiltInRegistries.FLUID.getKey((Object)fluid);
        return fluidName.toString();
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, context) -> new InfinityBucketWrapper((ItemStack)stack), new ItemLike[]{this});
    }

    @Override
    public void appendHoverText(@NotNull ItemStack pStack, @Nullable Item.TooltipContext context, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, context, pTooltipComponents, pIsAdvanced);
        List<FluidStack> fluids = InfinityBucketItem.getFluids(pStack);
        NumberFormat formater = DecimalFormat.getInstance();
        for (FluidStack fluid : fluids) {
            MutableComponent component = MutableComponent.create((ComponentContents)fluid.getHoverName().getContents());
            component.append(": " + formater.format(fluid.getAmount()) + " mB");
            pTooltipComponents.add((Component)component);
        }
    }

    public void inventoryTick(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        Player player;
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pLevel.isClientSide && pEntity instanceof Player && (player = (Player)pEntity).getInventory().getSelected() == pStack) {
            FluidStack firstContained = InfinityBucketItem.getFluids(pStack).stream().findFirst().orElse(FluidStack.EMPTY);
            NumberFormat formater = DecimalFormat.getInstance();
            String displayName = firstContained.getHoverName().getString();
            String amount = formater.format(firstContained.getAmount());
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.infinity_bucket.message", (Object[])new Object[]{displayName, amount}), true);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        FluidActionResult placeResult;
        FluidStack drained;
        FluidActionResult pickUpResult;
        boolean canPickUp;
        ItemStack itemStack = pPlayer.getItemInHand(pUsedHand);
        if (pPlayer.isCrouching()) {
            List<FluidStack> fluids = InfinityBucketItem.getFluids(itemStack);
            if (fluids.isEmpty()) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            FluidStack firstContained = fluids.remove(0);
            fluids.add(firstContained);
            InfinityBucketItem.setFluids(itemStack, fluids);
            return InteractionResultHolder.success((Object)itemStack);
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        if (fluidHandler == null) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        BlockHitResult hitResult = InfinityBucketItem.getPlayerPOVHitResult((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        BlockPos hitPos = hitResult.getBlockPos();
        BlockState hitState = pLevel.getBlockState(hitPos);
        Block hitBlock = hitState.getBlock();
        boolean bl = canPickUp = hitBlock instanceof LiquidBlock || hitBlock instanceof BucketPickup;
        if (pLevel.mayInteract(pPlayer, hitPos) && canPickUp && (pickUpResult = FluidUtil.tryPickUpFluid((ItemStack)itemStack, (Player)pPlayer, (Level)pLevel, (BlockPos)hitPos, (Direction)hitResult.getDirection())).isSuccess()) {
            return InteractionResultHolder.success((Object)pickUpResult.getResult());
        }
        BlockPos placePos = hitPos.offset(hitResult.getDirection().getNormal());
        if (pLevel.mayInteract(pPlayer, placePos) && (drained = fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE)).getAmount() == 1000 && (placeResult = FluidUtil.tryPlaceFluid((Player)pPlayer, (Level)pLevel, (InteractionHand)pUsedHand, (BlockPos)placePos, (ItemStack)itemStack, (FluidStack)drained)).isSuccess()) {
            fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            return InteractionResultHolder.success((Object)placeResult.getResult());
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }
}

