/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.misc;

import committee.nova.mods.avaritia.common.item.resources.ResourceItem;
import committee.nova.mods.avaritia.common.tile.collector.BaseNeutronCollectorTile;
import committee.nova.mods.avaritia.common.tile.collector.CollectorTier;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class InfinityUpgradeItem
extends ResourceItem {
    public InfinityUpgradeItem(String registryName) {
        super((Rarity)ModRarities.LEGEND.getValue(), registryName, true, new Item.Properties().durability(16));
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isValidRepairItem(@NotNull ItemStack pStack, @NotNull ItemStack pRepairCandidate) {
        return pRepairCandidate.is((Item)ModItems.star_fuel.get());
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        BlockEntity tile = pContext.getLevel().getBlockEntity(pContext.getClickedPos());
        Player player = pContext.getPlayer();
        ItemStack itemInHand = pContext.getItemInHand();
        if (tile instanceof BaseNeutronCollectorTile) {
            ServerPlayer serverPlayer;
            BaseNeutronCollectorTile collectorTile = (BaseNeutronCollectorTile)tile;
            if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).isCrouching()) {
                switch (collectorTile.getTier()) {
                    case DEFAULT: {
                        collectorTile.setTier(CollectorTier.DENSE);
                        level.setBlockAndUpdate(blockpos, ((Block)ModBlocks.dense_neutron_collector.get()).withPropertiesOf(blockstate));
                        level.playSound((Player)serverPlayer, blockpos, SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS);
                        itemInHand.consume(1, (LivingEntity)serverPlayer);
                        return InteractionResult.SUCCESS;
                    }
                    case DENSE: {
                        collectorTile.setTier(CollectorTier.DENSER);
                        level.setBlockAndUpdate(blockpos, ((Block)ModBlocks.denser_neutron_collector.get()).withPropertiesOf(blockstate));
                        level.playSound((Player)serverPlayer, blockpos, SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS);
                        itemInHand.consume(1, (LivingEntity)serverPlayer);
                        return InteractionResult.SUCCESS;
                    }
                }
                return InteractionResult.PASS;
            }
        }
        return super.useOn(pContext);
    }
}

