/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.utils.lang.TextUtils;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModArmorMaterial;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityArmorItem
extends ArmorItem {
    public InfinityArmorItem(ArmorItem.Type pSlot) {
        super(ModArmorMaterial.infinite_armor, pSlot, new Item.Properties().rarity((Rarity)ModRarities.COSMIC.getValue()).fireResistant().stacksTo(1));
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isEnderMask(@NotNull ItemStack stack, @NotNull Player player, @NotNull EnderMan enderMan) {
        return true;
    }

    public boolean makesPiglinsNeutral(@NotNull ItemStack stack, @NotNull LivingEntity wearer) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        if (this.type.getSlot() == EquipmentSlot.HEAD) {
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "+" + String.valueOf(ChatFormatting.ITALIC) + TextUtils.makeSANIC(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])) + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.BLUE) + "% ")).append(I18n.get((String)"effect.minecraft.night_vision", (Object[])new Object[0])));
        }
        if (this.type.getSlot() == EquipmentSlot.CHEST) {
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "+" + String.valueOf(ChatFormatting.ITALIC) + TextUtils.makeSANIC(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])) + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.BLUE) + "% ")).append(I18n.get((String)"attribute.name.generic.flying_speed", (Object[])new Object[0])));
        }
        if (this.type.getSlot() == EquipmentSlot.LEGS) {
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "+" + String.valueOf(ChatFormatting.ITALIC) + TextUtils.makeSANIC(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])) + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.BLUE) + "% ")).append(I18n.get((String)"attribute.name.generic.walking_speed", (Object[])new Object[0])));
        }
        if (this.type.getSlot() == EquipmentSlot.FEET) {
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "+" + String.valueOf(ChatFormatting.ITALIC) + TextUtils.makeSANIC(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])) + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.BLUE) + "% ")).append(I18n.get((String)"attribute.name.generic.movement_speed", (Object[])new Object[0])));
        }
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
    }

    public boolean hasCustomEntity(@NotNull ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(@NotNull Level level, Entity location, @NotNull ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }

    @Nullable
    public ResourceLocation getArmorTexture(@NotNull ItemStack stack, @NotNull Entity entity, @NotNull EquipmentSlot slot, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorMaterial.Layer layer, boolean innerModel) {
        return Const.rl("textures/models/infinity_armor.png");
    }
}

