/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.blaze;

import committee.nova.mods.avaritia.api.common.enchant.InitEnchantment;
import committee.nova.mods.avaritia.api.common.item.iface.IItemEnchant;
import committee.nova.mods.avaritia.api.common.item.iface.mode.IItemMode;
import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.init.registry.ModDataComponents;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import committee.nova.mods.avaritia.init.registry.modes.ToolMode;
import committee.nova.mods.avaritia.util.ToolUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlazeAxeItem
extends AxeItem
implements ITooltip,
IItemMode<ToolMode>,
IItemEnchant {
    private final String name;
    private final InitEnchantment initEnchantment;

    public BlazeAxeItem(String name) {
        super(ModToolTiers.BLAZE, new Item.Properties().component(ModDataComponents.TOOL_MODE, (Object)ToolMode.DEFAULT).rarity(ModRarities.EPIC).stacksTo(1).fireResistant().attributes(BlazeAxeItem.createAttributes((Tier)ModToolTiers.BLAZE, (float)0.0f, (float)ModToolTiers.BLAZE.getSpeed())));
        this.name = name;
        this.initEnchantment = new InitEnchantment((ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT, 10);
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    @Override
    public int getInitEnchantLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        return this.initEnchantment.getLevel(enchantment);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        this.initEnchantment.appendHoverText(context, tooltipComponents);
        this.appendTooltip(stack, context, tooltipComponents, isAdvanced, this.name);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching() && !world.isClientSide) {
            this.changeMode(player, stack, hand, ToolMode.ADVANCE);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(world, player, hand);
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity miningEntity) {
        if (((ToolMode)this.getMode(stack)).equals(ToolMode.ADVANCE) && miningEntity instanceof Player) {
            Player player = (Player)miningEntity;
            ToolUtils.melting(state, level, pos, player, stack);
        }
        return super.mineBlock(stack, level, state, pos, miningEntity);
    }

    @Override
    public DataComponentType<ToolMode> getDataComponentType() {
        return (DataComponentType)ModDataComponents.TOOL_MODE.get();
    }

    @Override
    public ToolMode getDefaultMode() {
        return ToolMode.DEFAULT;
    }
}

