/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.blaze;

import committee.nova.mods.avaritia.api.common.enchant.InitEnchantment;
import committee.nova.mods.avaritia.api.common.item.iface.IItemEnchant;
import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlazeShovelItem
extends ShovelItem
implements ITooltip,
IItemEnchant {
    private final String name;
    private final InitEnchantment initEnchantment;

    public BlazeShovelItem(String name) {
        super(ModToolTiers.BLAZE, new Item.Properties().rarity(ModRarities.EPIC).stacksTo(1).fireResistant().attributes(BlazeShovelItem.createAttributes((Tier)ModToolTiers.BLAZE, (float)0.0f, (float)ModToolTiers.BLAZE.getSpeed())));
        this.name = name;
        this.initEnchantment = new InitEnchantment((ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT, 10);
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    @Override
    public int getInitEnchantLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        return this.initEnchantment.getLevel(enchantment);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        this.initEnchantment.appendHoverText(context, tooltipComponents);
        this.appendTooltip(stack, context, tooltipComponents, isAdvanced, this.name);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext pContext) {
        BlockPos blockpos;
        Level level = pContext.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = pContext.getClickedPos());
        if (blockstate.is(Blocks.GRAVEL)) {
            level.setBlockAndUpdate(blockpos, Blocks.NETHERRACK.defaultBlockState());
            return InteractionResult.SUCCESS;
        }
        if (blockstate.is(Blocks.SAND)) {
            level.setBlockAndUpdate(blockpos, Blocks.SOUL_SAND.defaultBlockState());
            return InteractionResult.SUCCESS;
        }
        if (blockstate.is(Blocks.DIRT)) {
            level.setBlockAndUpdate(blockpos, Blocks.SOUL_SOIL.defaultBlockState());
            return InteractionResult.SUCCESS;
        }
        return super.useOn(pContext);
    }
}

