/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.crystal;

import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CrystalHoeItem
extends HoeItem
implements ITooltip {
    private final String name;

    public CrystalHoeItem(String name) {
        super(ModToolTiers.CRYSTAL, new Item.Properties().rarity(ModRarities.EPIC).stacksTo(1).fireResistant().attributes(CrystalHoeItem.createAttributes((Tier)ModToolTiers.CRYSTAL, (float)0.0f, (float)ModToolTiers.BLAZE.getSpeed())));
        this.name = name;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        this.appendTooltip(stack, context, tooltipComponents, isAdvanced, this.name);
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        return super.use(world, player, hand);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext pContext) {
        super.useOn(pContext);
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        BlockState targetState = level.getBlockState(pos);
        Block targetBlock = targetState.getBlock();
        if (level instanceof ServerLevel) {
            BonemealableBlock growable;
            ServerLevel serverLevel = (ServerLevel)level;
            if (targetBlock instanceof BonemealableBlock && (growable = (BonemealableBlock)targetBlock).isValidBonemealTarget((LevelReader)serverLevel, pos, targetState)) {
                growable.performBonemeal(serverLevel, level.random, pos, targetState);
                serverLevel.levelEvent(2005, pos, 0);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.resetAttackStrengthTicker();
        }
        return super.onLeftClickEntity(stack, player, entity);
    }
}

