/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.crystal;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrystalShovelItem
extends ShovelItem
implements ITooltip {
    private final String name;

    public CrystalShovelItem(String name) {
        super(ModToolTiers.CRYSTAL, new Item.Properties().rarity(ModRarities.EPIC).stacksTo(1).fireResistant().attributes(CrystalShovelItem.createAttributes((Tier)ModToolTiers.CRYSTAL, (float)0.0f, (float)ModToolTiers.BLAZE.getSpeed())));
        this.name = name;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        this.appendTooltip(stack, context, tooltipComponents, isAdvanced, this.name);
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public void inventoryTick(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (!pLevel.isClientSide && pSlotId < Inventory.getSelectionSize() && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pIsSelected) {
                ArrayList effects = Lists.newArrayList((Iterable)player.getActiveEffects());
                for (MobEffectInstance potion2 : Collections2.filter((Collection)effects, potion -> potion.getEffect().equals((Object)MobEffects.MOVEMENT_SLOWDOWN) || potion.getEffect().equals((Object)MobEffects.DIG_SLOWDOWN))) {
                    player.removeEffect(potion2.getEffect());
                }
            }
        }
    }
}

