/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.crystal;

import committee.nova.mods.avaritia.api.common.item.iface.mode.IItemMode;
import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.init.registry.ModDataComponents;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import committee.nova.mods.avaritia.init.registry.modes.ToolMode;
import committee.nova.mods.avaritia.util.ToolUtils;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrystalSwordItem
extends SwordItem
implements ITooltip,
IItemMode<ToolMode> {
    private final String name;

    public CrystalSwordItem(String name) {
        super(ModToolTiers.CRYSTAL, new Item.Properties().component(ModDataComponents.TOOL_MODE, (Object)ToolMode.DEFAULT).rarity(ModRarities.EPIC).stacksTo(1).fireResistant().attributes(CrystalSwordItem.createAttributes((Tier)ModToolTiers.CRYSTAL, (int)0, (float)ModToolTiers.BLAZE.getSpeed())));
        this.name = name;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        this.appendTooltip(stack, context, tooltipComponents, isAdvanced, this.name);
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean onLeftClickEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity entity) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.resetAttackStrengthTicker();
        }
        entity.setInvulnerable(false);
        return super.onLeftClickEntity(stack, player, entity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching() && !world.isClientSide) {
            this.changeMode(player, stack, hand, ToolMode.ADVANCE);
            return InteractionResultHolder.success((Object)stack);
        }
        if (((ToolMode)this.getMode(stack)).equals(ToolMode.ADVANCE)) {
            ToolUtils.shootBladeSlash(stack, player);
        }
        return super.use(world, player, hand);
    }

    @Override
    public DataComponentType<ToolMode> getDataComponentType() {
        return (DataComponentType)ModDataComponents.TOOL_MODE.get();
    }

    @Override
    public ToolMode getDefaultMode() {
        return ToolMode.DEFAULT;
    }
}

