/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.common.entity.arrow.HeavenSubArrowEntity;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class InfinityCrossBowItem
extends CrossbowItem
implements ITooltip {
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;

    public InfinityCrossBowItem() {
        super(new Item.Properties().stacksTo(1).rarity((Rarity)ModRarities.COSMIC.getValue()).fireResistant());
    }

    private static float getShootingPower() {
        return 5.0f;
    }

    /*
     * Unable to fully structure code
     */
    public static void performShooting(@NotNull Level worldIn, LivingEntity shooter, @NotNull InteractionHand pUsedHand, ItemStack stack, int counts, float velocityIn, float inaccuracyIn) {
        if (shooter instanceof Player) {
            player = (Player)shooter;
            if (EventHooks.onArrowLoose((ItemStack)stack, (Level)shooter.level(), (Player)player, (int)1, (boolean)true) < 0) {
                return;
            }
        }
        afloat = InfinityCrossBowItem.getShotPitches(shooter.getRandom());
        if (!(shooter instanceof Player)) ** GOTO lbl-1000
        player = (Player)shooter;
        if (player.getAbilities().instabuild) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        flag = v0;
        for (i = 0; i < counts; ++i) {
            InfinityCrossBowItem.shootProjectile(worldIn, shooter, pUsedHand, stack, afloat[i < 10 ? 1 : 2], flag, velocityIn, inaccuracyIn, InfinityCrossBowItem.getArrowAngle(i, i < 10));
        }
        InfinityCrossBowItem.onCrossbowShot(worldIn, shooter, stack);
    }

    private static float getArrowAngle(int i, boolean flag) {
        return flag ? -((float)i * 12.0f - 24.0f) : (float)(i - 10) * 4.5f;
    }

    private static float[] getShotPitches(RandomSource rand) {
        boolean flag = rand.nextBoolean();
        return new float[]{1.0f, InfinityCrossBowItem.getRandomSoundPitch(flag, rand), InfinityCrossBowItem.getRandomSoundPitch(!flag, rand)};
    }

    private static float getRandomSoundPitch(boolean flagIn, RandomSource rand) {
        float f = flagIn ? 0.63f : 0.43f;
        return 1.0f / (rand.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static void onCrossbowShot(Level worldIn, LivingEntity shooter, ItemStack stack) {
        if (shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            if (!worldIn.isClientSide) {
                CriteriaTriggers.SHOT_CROSSBOW.trigger(serverPlayer, stack);
            }
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
        }
    }

    private static void shootProjectile(Level pLevel, LivingEntity pShooter, InteractionHand pHand, ItemStack pCrossbowStack, float pSoundPitch, boolean pIsCreativeMode, float pVelocity, float pInaccuracy, float pProjectileAngle) {
        if (!pLevel.isClientSide) {
            AbstractArrow projectile = InfinityCrossBowItem.getArrow(pShooter);
            if (pIsCreativeMode || pProjectileAngle != 0.0f) {
                projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            Vec3 vec31 = pShooter.getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(pProjectileAngle * ((float)Math.PI / 180)), vec31.x, vec31.y, vec31.z);
            Vec3 vec3 = pShooter.getViewVector(1.0f);
            Vector3f vector3f = vec3.toVector3f().rotate((Quaternionfc)quaternionf);
            projectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), pVelocity, pInaccuracy);
            pLevel.addFreshEntity((Entity)projectile);
            pLevel.playSound(null, pShooter.getX(), pShooter.getY(), pShooter.getZ(), SoundEvents.CROSSBOW_SHOOT, SoundSource.PLAYERS, 1.0f, pSoundPitch);
        }
    }

    private static AbstractArrow getArrow(LivingEntity shooter) {
        HeavenSubArrowEntity arrow = new HeavenSubArrowEntity((Entity)shooter);
        if (shooter instanceof Player) {
            arrow.setCritArrow(true);
        }
        arrow.setSoundEvent(SoundEvents.CROSSBOW_HIT);
        return arrow;
    }

    public static int getChargeDuration() {
        return 10;
    }

    private static float getPowerForTime(int useTime) {
        float f = (float)useTime / (float)InfinityCrossBowItem.getChargeDuration();
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static boolean isCharged(ItemStack pCrossbowStack) {
        ChargedProjectiles chargedprojectiles = (ChargedProjectiles)pCrossbowStack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY);
        return !chargedprojectiles.isEmpty();
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(@NotNull ItemStack pStack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 99;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack pStack) {
        return UseAnim.CROSSBOW;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return InfinityCrossBowItem.getChargeDuration() + 3;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (InfinityCrossBowItem.isCharged(itemstack)) {
            InfinityCrossBowItem.performShooting(level, (LivingEntity)player, hand, itemstack, 5, InfinityCrossBowItem.getShootingPower(), 1.0f);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        if (!InfinityCrossBowItem.isCharged(itemstack)) {
            this.startSoundPlayed = false;
            this.midLoadSoundPlayed = false;
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public void onUseTick(Level pLevel, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack pStack, int pCount) {
        if (!pLevel.isClientSide) {
            SoundEvent soundevent = (SoundEvent)SoundEvents.CROSSBOW_LOADING_START.value();
            SoundEvent soundevent1 = (SoundEvent)SoundEvents.CROSSBOW_LOADING_MIDDLE.value();
            float f = (float)(pStack.getUseDuration(pLivingEntity) - pCount) / (float)InfinityCrossBowItem.getChargeDuration();
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                pLevel.playSound(null, pLivingEntity.getX(), pLivingEntity.getY(), pLivingEntity.getZ(), soundevent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                pLevel.playSound(null, pLivingEntity.getX(), pLivingEntity.getY(), pLivingEntity.getZ(), soundevent1, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level pLevel, @NotNull LivingEntity entity, int pTimeLeft) {
        int i = this.getUseDuration(stack, entity) - pTimeLeft;
        float f = InfinityCrossBowItem.getPowerForTime(i);
        if (f >= 1.0f && !InfinityCrossBowItem.isCharged(stack)) {
            SoundSource soundcategory = entity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.CROSSBOW_LOADING_END, soundcategory, 1.0f, 1.0f / (entity.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }
}

