/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net;

import committee.nova.mods.avaritia.Const;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import org.jetbrains.annotations.NotNull;

public record S2CTotemPack(ItemStack stack, int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<S2CTotemPack> TYPE = new CustomPacketPayload.Type(Const.rl("s2c_totem"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CTotemPack> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, S2CTotemPack::stack, (StreamCodec)ByteBufCodecs.INT, S2CTotemPack::entityId, S2CTotemPack::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Handler
    implements IPayloadHandler<S2CTotemPack> {
        public void handle(@NotNull S2CTotemPack packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Entity entity;
                Minecraft instance = Minecraft.getInstance();
                ClientLevel world = instance.level;
                if (world != null && (entity = world.getEntity(packet.entityId)) != null) {
                    instance.particleEngine.createTrackingEmitter(entity, (ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, 30);
                    world.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TOTEM_USE, entity.getSoundSource(), 1.0f, 1.0f, false);
                    instance.gameRenderer.displayItemActivation(packet.stack);
                }
            });
        }
    }
}

