/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.common.crafting.ICompressorRecipe;
import committee.nova.mods.avaritia.api.common.crafting.ITierCraftingRecipe;
import committee.nova.mods.avaritia.api.common.crafting.TierInput;
import committee.nova.mods.avaritia.common.block.compressor.CompressorBlock;
import committee.nova.mods.avaritia.common.block.craft.TierCraftTableBlock;
import committee.nova.mods.avaritia.common.block.extreme.ExtremeSmithingTableBlock;
import committee.nova.mods.avaritia.common.crafting.recipe.ExtremeSmithingRecipe;
import committee.nova.mods.avaritia.common.tile.CompressorTile;
import committee.nova.mods.avaritia.common.tile.TierCraftTile;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)CompressorComponentProvider.INSTANCE, CompressorBlock.class);
        registration.registerBlockComponent((IComponentProvider)CraftingComponentProvider.INSTANCE, TierCraftTableBlock.class);
        registration.registerBlockComponent((IComponentProvider)ExtremeSmithingComponentProvider.INSTANCE, ExtremeSmithingTableBlock.class);
    }

    public static enum CompressorComponentProvider implements IBlockComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            CompressorTile compressor = (CompressorTile)accessor.getBlockEntity();
            ICompressorRecipe recipe = compressor.getActiveRecipe();
            if (recipe != null) {
                Level level = accessor.getLevel();
                ItemStack output = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
                tooltip.add((Component)ModTooltips.COMPRESS.args(output.getCount(), output.getHoverName()).build());
            }
        }

        public ResourceLocation getUid() {
            return Const.rl("compressor");
        }
    }

    public static final class CraftingComponentProvider
    extends Enum<CraftingComponentProvider>
    implements IBlockComponentProvider {
        public static final /* enum */ CraftingComponentProvider INSTANCE = new CraftingComponentProvider();
        private static final /* synthetic */ CraftingComponentProvider[] $VALUES;

        public static CraftingComponentProvider[] values() {
            return (CraftingComponentProvider[])$VALUES.clone();
        }

        public static CraftingComponentProvider valueOf(String name) {
            return Enum.valueOf(CraftingComponentProvider.class, name);
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            ClientLevel level = Minecraft.getInstance().level;
            assert (level != null);
            TierCraftTile craftTile = (TierCraftTile)accessor.getBlockEntity();
            ITierCraftingRecipe recipe = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get(), (RecipeInput)TierInput.of(craftTile.tier.size, craftTile.tier.size, craftTile.getInventory().getStacks(), craftTile.tier.ordinal()), (Level)level).map(RecipeHolder::value).orElse(null);
            if (recipe != null) {
                ItemStack output = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
                tooltip.add((Component)ModTooltips.CRAFTING.args(I18n.get((String)("jei.category.avaritia." + craftTile.tier.name), (Object[])new Object[0]), output.getCount(), output.getHoverName()).build());
            }
        }

        public ResourceLocation getUid() {
            return Const.rl("crafting_table");
        }

        private static /* synthetic */ CraftingComponentProvider[] $values() {
            return new CraftingComponentProvider[]{INSTANCE};
        }

        static {
            $VALUES = CraftingComponentProvider.$values();
        }
    }

    public static final class ExtremeSmithingComponentProvider
    extends Enum<ExtremeSmithingComponentProvider>
    implements IBlockComponentProvider {
        public static final /* enum */ ExtremeSmithingComponentProvider INSTANCE = new ExtremeSmithingComponentProvider();
        private static final /* synthetic */ ExtremeSmithingComponentProvider[] $VALUES;

        public static ExtremeSmithingComponentProvider[] values() {
            return (ExtremeSmithingComponentProvider[])$VALUES.clone();
        }

        public static ExtremeSmithingComponentProvider valueOf(String name) {
            return Enum.valueOf(ExtremeSmithingComponentProvider.class, name);
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            ClientLevel level = Minecraft.getInstance().level;
            assert (level != null);
            List recipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.EXTREME_SMITHING_RECIPE.get());
            if (!recipes.isEmpty()) {
                ExtremeSmithingRecipe recipe = (ExtremeSmithingRecipe)((RecipeHolder)recipes.get(0)).value();
                ItemStack output = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
                tooltip.add((Component)ModTooltips.SMITHING.args(output.getCount(), output.getHoverName()).build());
            }
        }

        public ResourceLocation getUid() {
            return Const.rl("extreme_smithing");
        }

        private static /* synthetic */ ExtremeSmithingComponentProvider[] $values() {
            return new ExtremeSmithingComponentProvider[]{INSTANCE};
        }

        static {
            $VALUES = ExtremeSmithingComponentProvider.$values();
        }
    }
}

