/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.emi.category;

import committee.nova.mods.avaritia.common.crafting.recipe.ExtremeSmithingRecipe;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public record ExtremeSmithingRecipeCategory(RecipeHolder<ExtremeSmithingRecipe> recipe) implements EmiRecipe
{
    private static final EmiTexture TEXTURE = new EmiTexture(ResourceLocation.tryBuild((String)"avaritia", (String)"textures/gui/jei/extreme_smithing_jei.png"), 0, 0, 169, 63);
    public static final EmiStack WORKSTATION = EmiStack.of((ItemLike)((ItemLike)ModBlocks.extreme_smithing_table.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(ResourceLocation.tryBuild((String)"avaritia", (String)"extreme_smithing_table"), (EmiRenderable)WORKSTATION);

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    @NotNull
    public ResourceLocation getId() {
        return this.recipe.id();
    }

    public List<EmiIngredient> getInputs() {
        return ((ExtremeSmithingRecipe)this.recipe.value()).getIngredients().stream().map(EmiIngredient::of).toList();
    }

    public List<EmiStack> getOutputs() {
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        return List.of(EmiStack.of((ItemStack)((ExtremeSmithingRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess())));
    }

    public int getDisplayWidth() {
        return 171;
    }

    public int getDisplayHeight() {
        return 65;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(TEXTURE, 1, 1);
        widgets.addSlot(EmiIngredient.of((Ingredient)((ExtremeSmithingRecipe)this.recipe.value()).template), 27, 23).drawBack(false);
        widgets.addSlot(EmiIngredient.of((Ingredient)((ExtremeSmithingRecipe)this.recipe.value()).base), 45, 23).drawBack(false);
        widgets.addSlot(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{Arrays.stream(((ExtremeSmithingRecipe)this.recipe.value()).additions.getItems()).toList().get(0)})), 45, 5).drawBack(false);
        widgets.addSlot(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{Arrays.stream(((ExtremeSmithingRecipe)this.recipe.value()).additions.getItems()).toList().get(1)})), 63, 23).drawBack(false);
        widgets.addSlot(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{Arrays.stream(((ExtremeSmithingRecipe)this.recipe.value()).additions.getItems()).toList().get(2)})), 45, 41).drawBack(false);
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)ExtremeSmithingRecipeCategory.getResultItem(this.recipe.value())), 117, 23).recipeContext((EmiRecipe)this).drawBack(false);
    }

    public static ItemStack getResultItem(Recipe<?> recipe) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.registryAccess();
        return recipe.getResultItem((HolderLookup.Provider)registryAccess);
    }
}

