/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.jei.category;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.common.crafting.ICompressorRecipe;
import committee.nova.mods.avaritia.api.utils.lang.Localizable;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CompressorCategory
implements IRecipeCategory<ICompressorRecipe> {
    public static final RecipeType<ICompressorRecipe> RECIPE_TYPE = RecipeType.create((String)"avaritia", (String)"compressor", ICompressorRecipe.class);
    private static final ResourceLocation TEXTURE = Const.rl("textures/gui/jei/compressor.png");
    private final IDrawable icon;
    private final IDrawable background;

    public CompressorCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.neutron_compressor.get()));
        this.background = helper.createDrawable(TEXTURE, 0, 0, 170, 63);
    }

    @NotNull
    public RecipeType<ICompressorRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Localizable.of("jei.category.avaritia.compressor").build();
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICompressorRecipe recipe, @NotNull IFocusGroup focuses) {
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        NonNullList inputs = recipe.getIngredients();
        ItemStack output = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        builder.addSlot(RecipeIngredientRole.INPUT, 37, 21).addIngredients((Ingredient)inputs.get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 117, 21).addItemStack(output);
        builder.moveRecipeTransferButton(160, 68);
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, @NotNull ICompressorRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 62.0 && mouseX < 77.0 && mouseY > 21.0 && mouseY < 36.0) {
            tooltip.add((FormattedText)ModTooltips.NUM_ITEMS.args(recipe.getInputCount()).color(ChatFormatting.LIGHT_PURPLE).build());
        }
        if (mouseX > 86.0 && mouseX < 107.0 && mouseY > 22.0 && mouseY < 36.0) {
            tooltip.add((FormattedText)ModTooltips.TIME_CONSUME.args(recipe.getTimeCost()).color(ChatFormatting.BLUE).build());
        }
    }
}

