/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.jei.category;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.utils.lang.Localizable;
import committee.nova.mods.avaritia.common.crafting.recipe.ExtremeSmithingRecipe;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import java.util.Arrays;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ExtremeSmithingRecipeCategory
implements IRecipeCategory<ExtremeSmithingRecipe> {
    public static final RecipeType<ExtremeSmithingRecipe> RECIPE_TYPE = RecipeType.create((String)"avaritia", (String)"extreme_smithing", ExtremeSmithingRecipe.class);
    private static final ResourceLocation TEXTURE = Const.rl("textures/gui/jei/extreme_smithing_jei.png");
    private final IDrawable icon;
    private final IDrawable background;

    public ExtremeSmithingRecipeCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.extreme_smithing_table.get()));
        this.background = helper.createDrawable(TEXTURE, 0, 0, 170, 64);
    }

    @NotNull
    public RecipeType<ExtremeSmithingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Localizable.of("jei.category.avaritia.extreme_smithing_table").build();
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, @NotNull ExtremeSmithingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 27, 23).addIngredients(recipe.template);
        builder.addSlot(RecipeIngredientRole.INPUT, 45, 23).addIngredients(recipe.base);
        builder.addSlot(RecipeIngredientRole.INPUT, 45, 5).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{Arrays.stream(recipe.additions.getItems()).toList().get(0)}));
        builder.addSlot(RecipeIngredientRole.INPUT, 63, 23).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{Arrays.stream(recipe.additions.getItems()).toList().get(1)}));
        builder.addSlot(RecipeIngredientRole.INPUT, 45, 41).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{Arrays.stream(recipe.additions.getItems()).toList().get(2)}));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 117, 23).addItemStack(ExtremeSmithingRecipeCategory.getResultItem(recipe));
        builder.moveRecipeTransferButton(160, 68);
    }

    public static ItemStack getResultItem(Recipe<?> recipe) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.registryAccess();
        return recipe.getResultItem((HolderLookup.Provider)registryAccess);
    }

    public boolean isHandled(@NotNull ExtremeSmithingRecipe recipe) {
        if (recipe.isIncomplete()) {
            return false;
        }
        return recipe instanceof ExtremeSmithingRecipe;
    }
}

