/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.config;

import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ModConfig {
    public static final ModConfigSpec COMMON;
    public static final ModConfigSpec.BooleanValue isInfinityLight;
    public static final ModConfigSpec.DoubleValue foodTime;
    public static final ModConfigSpec.BooleanValue isKeepStone;
    public static final ModConfigSpec.BooleanValue isMergeMatterCluster;
    public static final ModConfigSpec.IntValue swordRangeDamage;
    public static final ModConfigSpec.IntValue swordAttackRange;
    public static final ModConfigSpec.BooleanValue isSwordAttackAnimal;
    public static final ModConfigSpec.BooleanValue isSwordAttackLightning;
    public static final ModConfigSpec.BooleanValue isSwordAttackEndless;
    public static final ModConfigSpec.IntValue subArrowDamage;
    public static final ModConfigSpec.IntValue axeChainCount;
    public static final ModConfigSpec.IntValue pickAxeBreakRange;
    public static final ModConfigSpec.IntValue shovelBreakRange;
    public static final ModConfigSpec.IntValue neutronCollectorProductTick;
    public static final ModConfigSpec.IntValue singularityTimeRequired;
    public static final ModConfigSpec.DoubleValue growthSoulFarmland;
    public static final ModConfigSpec.IntValue bladeSlashDamage;
    public static final ModConfigSpec.IntValue bladeSlashRadius;
    public static final ModConfigSpec.BooleanValue internalInfinityCatalystCraft;
    public static final ModConfigSpec.IntValue neutronPileEmc;
    public static final ModConfigSpec.IntValue vanillaTotemEmc;
    public static final ModConfigSpec.IntValue chestMaxItemSize;
    public static final ModConfigSpec.BooleanValue useSinglePageMode;
    public static final ModConfigSpec.LongValue slotStackLimit;
    public static final ModConfigSpec.IntValue maxPageLimit;
    public static final ModConfigSpec.IntValue resetMaxPage;
    public static final ModConfigSpec.IntValue inventoryRows;
    public static ModConfigSpec.IntValue MAX_SIZE_PRE_CHANNEL;
    public static ModConfigSpec.IntValue MAX_CHANNELS_PRE_PLAYER;
    public static ModConfigSpec.IntValue MAX_PUBLIC_CHANNELS;
    public static ModConfigSpec.IntValue CHANNEL_FAST_UPDATE_RATE;
    public static ModConfigSpec.IntValue CHANNEL_FULL_UPDATE_RATE;
    public static final ModConfigSpec.BooleanValue useAdvanceTooltips;

    public static void register(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON);
    }

    private static ModConfigSpec.BooleanValue buildBoolean(ModConfigSpec.Builder builder, String name, boolean defaultValue, String comment) {
        return builder.comment(comment).translation(name).define(name, defaultValue);
    }

    private static ModConfigSpec.IntValue buildInt(ModConfigSpec.Builder builder, String name, int defaultValue, int min, int max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    private static ModConfigSpec.DoubleValue buildDouble(ModConfigSpec.Builder builder, String name, double defaultValue, double min, double max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    private static ModConfigSpec.LongValue buildLong(ModConfigSpec.Builder builder, String name, long defaultValue, long min, long max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    static {
        ModConfigSpec.Builder common = new ModConfigSpec.Builder();
        common.comment("Avaritia Common Config");
        common.push("tools");
        isInfinityLight = ModConfig.buildBoolean(common, "Is Infinity Light", false, "The blocks near the infinity blocks are the brightest");
        common.pop();
        common.push("tools");
        isKeepStone = ModConfig.buildBoolean(common, "Is Stone", false, "Does the super mode of endless tools retain stone and soil");
        isMergeMatterCluster = ModConfig.buildBoolean(common, "Is Merge Matter Cluster", true, "Whether to merge matter cluster");
        swordRangeDamage = ModConfig.buildInt(common, "Sword Range Damage", 10000, 100, 100000, "Range damage value of the right key of Infinity sword");
        swordAttackRange = ModConfig.buildInt(common, "Sword Attack Range", 32, 8, 64, "Infinity sword right click attack range");
        isSwordAttackAnimal = ModConfig.buildBoolean(common, "Is Sword Damage Animal", false, "Does the right key range attack of endless sword attack neutral creatures");
        isSwordAttackLightning = ModConfig.buildBoolean(common, "Is Sword Cause Lightning", false, "Does the right key spawn lightning with range of attack");
        isSwordAttackEndless = ModConfig.buildBoolean(common, "Is Sword Cause Endless damage", true, "Does the right key cause infinity damage");
        subArrowDamage = ModConfig.buildInt(common, "Sub Arrow Damage", 10000, 100, 100000, "Infinity bow scattering light arrow damage");
        axeChainCount = ModConfig.buildInt(common, "Axe Chain Count", 64, 16, 128, "Chain number of endless axe cutting trees");
        foodTime = ModConfig.buildDouble(common, "Food Time", 1.0, 0.1, 5.0, "Food effect time scaling factor");
        pickAxeBreakRange = ModConfig.buildInt(common, "PickAxe Break Range", 8, 2, 32, "The range of Infinity PickAxe can break");
        shovelBreakRange = ModConfig.buildInt(common, "Shovel Break Range", 8, 2, 32, "The range of Infinity Shovel can break");
        neutronCollectorProductTick = ModConfig.buildInt(common, "Neutron Collector Product Tick", 3600, 1200, Integer.MAX_VALUE, "The product tick of NeutronCollector");
        singularityTimeRequired = ModConfig.buildInt(common, "Singularity Time Required", 240, 0, Integer.MAX_VALUE, "Singularity default time required");
        growthSoulFarmland = ModConfig.buildDouble(common, "Growth soul farmland rate", 0.8, 0.0, 1.0, "Growth soul farmland rate");
        bladeSlashDamage = ModConfig.buildInt(common, "BladeSlash Damage", 200, 0, Integer.MAX_VALUE, "Damage of BladeSlash for Crystal Sword");
        bladeSlashRadius = ModConfig.buildInt(common, "BladeSlash Radius", 10, 5, 100, "Radius of BladeSlash for Crystal Sword");
        internalInfinityCatalystCraft = ModConfig.buildBoolean(common, "Internal InfinityCatalyst Craft", true, "Is InfinityCatalyst Craft use all Singularity");
        common.pop();
        common.push("emc");
        neutronPileEmc = ModConfig.buildInt(common, "Neutron Pile Emc", 100, 0, Integer.MAX_VALUE, "Emc of Neutron Pile");
        vanillaTotemEmc = ModConfig.buildInt(common, "Vanilla Totem Emc", 1000, 0, Integer.MAX_VALUE, "Emc of Totem Of Undying");
        common.pop();
        common.push("storage");
        chestMaxItemSize = ModConfig.buildInt(common, "Chest Max ItemSize", 32768, 2048, Integer.MAX_VALUE, "Define the maximum number of item .types. that can be stored in a Infinity Chest.");
        useSinglePageMode = ModConfig.buildBoolean(common, "Use Single PageMode", false, "Use single page mode");
        slotStackLimit = ModConfig.buildLong(common, "Slot Stack Limit", 0xFFFFFFFFL, 64L, 0xFFFFFFFFL, "Stack size limit of slot");
        maxPageLimit = ModConfig.buildInt(common, "Max Page Limit", 79536431, 2, 79536431, "Maximum page limit");
        resetMaxPage = ModConfig.buildInt(common, "Reset Max Page", 1, 1, 79536431, "*Recovery options* Reset the max page that is 0.");
        inventoryRows = ModConfig.buildInt(common, "Inventory Rows", 6, 1, 6, "Inventory rows for multi page mode");
        common.pop();
        common.push("channel");
        MAX_SIZE_PRE_CHANNEL = ModConfig.buildInt(common, "Channel Size", 32768, 2048, Integer.MAX_VALUE, "");
        MAX_CHANNELS_PRE_PLAYER = ModConfig.buildInt(common, "MaxPlayer Channels", 16, 4, 64, "");
        MAX_PUBLIC_CHANNELS = ModConfig.buildInt(common, "MaxPublic Channels", 128, 32, 1024, "");
        CHANNEL_FAST_UPDATE_RATE = ModConfig.buildInt(common, "FastUpdate Rate", 1, 1, 40, "");
        CHANNEL_FULL_UPDATE_RATE = ModConfig.buildInt(common, "FullUpdate Rate", 40, 20, 1200, "");
        common.pop();
        common.push("misc");
        useAdvanceTooltips = ModConfig.buildBoolean(common, "Use Advance Tooltips", false, "For develop");
        common.pop();
        COMMON = common.build();
    }
}

