/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.data.provider.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapedTableCraftingRecipe;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;

public class ModShapedRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final ItemLike result;
    private final ItemStack resultStack;
    private final int tier;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private ICondition[] conditions;

    public ModShapedRecipeBuilder(RecipeCategory category, ItemLike result, int count) {
        this(category, new ItemStack(result, count), 4);
    }

    public ModShapedRecipeBuilder(RecipeCategory category, ItemLike result, int count, int tier) {
        this(category, new ItemStack(result, count), tier);
    }

    public ModShapedRecipeBuilder(RecipeCategory category, ItemStack result) {
        this(category, result, 4);
    }

    public ModShapedRecipeBuilder(RecipeCategory category, ItemStack result, int tier) {
        this.category = category;
        this.result = result.getItem();
        this.resultStack = result;
        this.tier = tier;
    }

    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ItemLike result) {
        return ModShapedRecipeBuilder.shaped(category, result, 4);
    }

    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ItemLike result, int tier) {
        return new ModShapedRecipeBuilder(category, new ItemStack(result, 1), tier);
    }

    public static ModShapedRecipeBuilder shaped(RecipeCategory category, ItemStack result, int tier) {
        return new ModShapedRecipeBuilder(category, result, tier);
    }

    public ModShapedRecipeBuilder define(Character symbol, TagKey<Item> tag) {
        return this.define(symbol, Ingredient.of(tag));
    }

    public ModShapedRecipeBuilder define(Character symbol, ItemStack item) {
        return this.define(symbol, DataComponentIngredient.of((boolean)true, (ItemStack)item));
    }

    public ModShapedRecipeBuilder define(Character symbol, ItemLike item) {
        return this.define(symbol, Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public ModShapedRecipeBuilder define(Character character, Ingredient ingredient) {
        if (this.key.containsKey(character)) {
            throw new IllegalArgumentException("Symbol '" + character + "' is already defined!");
        }
        if (character.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(character, ingredient);
        return this;
    }

    public ModShapedRecipeBuilder pattern(String s) {
        if (!this.rows.isEmpty() && s.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(s);
        return this;
    }

    @NotNull
    public RecipeBuilder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public ModShapedRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    @NotNull
    public ModShapedRecipeBuilder conditions(ICondition ... conditions) {
        this.conditions = conditions;
        return this;
    }

    @NotNull
    public Item getResult() {
        if (this.result != null) {
            return this.result.asItem();
        }
        return Items.AIR;
    }

    public void save(RecipeOutput recipeOutput, @NotNull ResourceLocation id) {
        ShapedRecipePattern shapedrecipepattern = this.ensureValid(id);
        Advancement.Builder advancement$builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        ShapedTableCraftingRecipe shapedrecipe = new ShapedTableCraftingRecipe(shapedrecipepattern, this.resultStack, this.tier);
        AdvancementHolder advancement = advancement$builder.build(id.withPrefix("recipes/" + this.category.getFolderName() + "/"));
        if (this.conditions != null) {
            recipeOutput.accept(id, (Recipe)shapedrecipe, advancement, this.conditions);
        } else {
            recipeOutput.accept(id, (Recipe)shapedrecipe, advancement);
        }
    }

    private ShapedRecipePattern ensureValid(ResourceLocation resourceLocation) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(resourceLocation));
        }
        return ShapedRecipePattern.of(this.key, this.rows);
    }
}

