/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.handler;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.utils.PlayerUtils;
import committee.nova.mods.avaritia.common.item.tools.InfinityArmorItem;
import committee.nova.mods.avaritia.util.ToolUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class AbilityHandler {
    public static final Set<String> entitiesWithHelmets = new HashSet<String>();
    public static final Set<String> entitiesWithLeggings = new HashSet<String>();
    public static final Set<String> entitiesWithBoots = new HashSet<String>();
    public static final Map<String, FlightInfo> entitiesWithFlight = new ConcurrentHashMap<String, FlightInfo>();

    @SubscribeEvent
    public static void updateAbilities(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String key = player.getGameProfile().getName() + ":" + player.level().isClientSide;
            boolean hasHelmet = ToolUtils.isPlayerWearing((LivingEntity)player, EquipmentSlot.HEAD, item -> item instanceof InfinityArmorItem);
            boolean hasChest = ToolUtils.isPlayerWearing((LivingEntity)player, EquipmentSlot.CHEST, item -> item instanceof InfinityArmorItem);
            boolean hasLeggings = ToolUtils.isPlayerWearing((LivingEntity)player, EquipmentSlot.LEGS, item -> item instanceof InfinityArmorItem);
            boolean hasBoots = ToolUtils.isPlayerWearing((LivingEntity)player, EquipmentSlot.FEET, item -> item instanceof InfinityArmorItem);
            AbilityHandler.handleHelmetStateChange(player, key, hasHelmet);
            AbilityHandler.handleChestStateChange(player, key, hasChest);
            AbilityHandler.handleLeggingsStateChange(player, key, hasLeggings);
            AbilityHandler.handleBootsStateChange(player, key, hasBoots);
        }
    }

    private static void handleChestStateChange(Player player, String key, boolean hasChest) {
        boolean isFlyingGameMode = !PlayerUtils.isPlayingMode(player);
        FlightInfo flightInfo = entitiesWithFlight.computeIfAbsent(key, uuid -> new FlightInfo());
        if (isFlyingGameMode || hasChest) {
            if (!flightInfo.hadFlightItem) {
                if (!player.getAbilities().mayfly) {
                    AbilityHandler.updateClientServerFlight(player, true);
                }
                flightInfo.hadFlightItem = true;
            } else if (flightInfo.wasFlyingGameMode && !isFlyingGameMode) {
                AbilityHandler.updateClientServerFlight(player, true, flightInfo.wasFlying);
            } else if (flightInfo.wasFlyingAllowed && !player.getAbilities().mayfly) {
                AbilityHandler.updateClientServerFlight(player, true, flightInfo.wasFlying);
            }
            flightInfo.wasFlyingGameMode = isFlyingGameMode;
            flightInfo.wasFlying = player.getAbilities().flying;
            flightInfo.wasFlyingAllowed = player.getAbilities().mayfly;
            if (hasChest) {
                ArrayList effects = Lists.newArrayList((Iterable)player.getActiveEffects());
                for (MobEffectInstance potion2 : Collections2.filter((Collection)effects, potion -> !((MobEffect)potion.getEffect().value()).isBeneficial())) {
                    player.removeEffect(potion2.getEffect());
                }
            }
        } else {
            if (flightInfo.hadFlightItem) {
                if (player.getAbilities().mayfly) {
                    AbilityHandler.updateClientServerFlight(player, false);
                }
                flightInfo.hadFlightItem = false;
            }
            flightInfo.wasFlyingGameMode = false;
            flightInfo.wasFlying = player.getAbilities().flying;
            flightInfo.wasFlyingAllowed = player.getAbilities().mayfly;
        }
    }

    private static void handleHelmetStateChange(Player player, String key, boolean hasHelmet) {
        if (hasHelmet) {
            if (entitiesWithHelmets.contains(key)) {
                player.setAirSupply(300);
                player.getFoodData().setFoodLevel(20);
                player.getFoodData().setSaturation(20.0f);
                MobEffectInstance nv = player.getEffect(MobEffects.NIGHT_VISION);
                if (nv == null) {
                    nv = new MobEffectInstance(MobEffects.NIGHT_VISION, 300, 0, false, false);
                    player.addEffect(nv);
                }
                nv.duration = 300;
            } else {
                entitiesWithHelmets.add(key);
            }
        } else {
            entitiesWithHelmets.remove(key);
        }
    }

    private static void handleLeggingsStateChange(Player player, String key, boolean hasLeggings) {
        if (hasLeggings) {
            if (entitiesWithLeggings.contains(key)) {
                if (player.isOnFire()) {
                    player.clearFire();
                    player.fireImmune();
                }
            } else {
                entitiesWithLeggings.add(key);
            }
        } else {
            entitiesWithLeggings.remove(key);
        }
    }

    private static void handleBootsStateChange(Player player, String key, boolean hasBoots) {
        if (hasBoots) {
            if (entitiesWithBoots.contains(key)) {
                Objects.requireNonNull(player.getAttribute(Attributes.STEP_HEIGHT)).addOrUpdateTransientModifier(new AttributeModifier(Const.rl("avaritia_boots"), 0.4624999761581421, AttributeModifier.Operation.ADD_VALUE));
                boolean flying = player.getAbilities().flying;
                boolean swimming = player.isInWater();
                boolean sneaking = player.isCrouching();
                if (player.onGround() || flying || swimming) {
                    float speed = 0.1f * (flying ? 1.1f : 1.0f) * (swimming ? 1.2f : 1.0f) * (sneaking ? 0.1f : 1.0f);
                    if (player.zza > 0.0f) {
                        player.moveRelative(speed, new Vec3(0.0, 0.0, 1.0));
                    } else if (player.zza < 0.0f) {
                        player.moveRelative(-speed * 0.25f, new Vec3(0.0, 0.0, 1.0));
                    }
                    if (player.xxa != 0.0f) {
                        player.moveRelative(speed * 0.45f * Math.signum(player.xxa), new Vec3(1.0, 0.0, 0.0));
                    }
                }
                if (player.isSprinting()) {
                    float f = player.getYRot() * ((float)Math.PI / 180);
                    player.setDeltaMovement(player.getDeltaMovement().add((double)(-Mth.sin((float)f) * 0.2f), 0.0, (double)(Mth.cos((float)f) * 0.2f)));
                }
            } else {
                entitiesWithBoots.add(key);
            }
        } else {
            Objects.requireNonNull(player.getAttribute(Attributes.STEP_HEIGHT)).removeModifier(Const.rl("avaritia_boots"));
            entitiesWithBoots.remove(key);
        }
    }

    @SubscribeEvent
    public static void jumpBoost(LivingEvent.LivingJumpEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && entitiesWithBoots.contains((player = (Player)entity).getGameProfile().getName() + ":" + player.level().isClientSide) && player.isSprinting()) {
            player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)0.305f, 0.0));
        }
    }

    @SubscribeEvent
    public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        AbilityHandler.stripAbilities(event.getEntity());
        AbilityHandler.reapplyFly(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        AbilityHandler.stripAbilities(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        AbilityHandler.stripAbilities(event.getEntity());
        AbilityHandler.clearFly(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        AbilityHandler.stripAbilities(event.getEntity());
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player entity = (Player)livingEntity;
            AbilityHandler.stripAbilities(entity);
        }
    }

    private static void stripAbilities(Player player) {
        String key = player.getGameProfile().getName() + ":" + player.level().isClientSide;
        entitiesWithHelmets.remove(key);
        entitiesWithFlight.remove(key);
        entitiesWithLeggings.remove(key);
        entitiesWithBoots.remove(key);
    }

    private static void clearFly(Player player) {
        entitiesWithFlight.remove(player.getGameProfile().getName() + ":" + player.level().isClientSide);
    }

    private static void reapplyFly(Player player) {
        FlightInfo flightInfo = entitiesWithFlight.get(player.getGameProfile().getName() + ":" + player.level().isClientSide);
        if (flightInfo != null && (flightInfo.wasFlyingAllowed || flightInfo.wasFlying)) {
            AbilityHandler.updateClientServerFlight(player, flightInfo.wasFlyingAllowed, flightInfo.wasFlying);
        }
    }

    private static void updateClientServerFlight(Player player, boolean allowFlying) {
        AbilityHandler.updateClientServerFlight(player, allowFlying, allowFlying && player.getAbilities().flying);
    }

    private static void updateClientServerFlight(Player player, boolean allowFlying, boolean isFlying) {
        player.getAbilities().mayfly = allowFlying;
        player.getAbilities().flying = isFlying;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.onUpdateAbilities();
        }
    }

    public static class FlightInfo {
        public boolean hadFlightItem;
        public boolean wasFlyingGameMode;
        public boolean wasFlyingAllowed;
        public boolean wasFlying;
    }
}

