/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.handler;

import committee.nova.mods.avaritia.api.utils.lang.TextUtils;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.common.item.resources.MatterClusterItem;
import committee.nova.mods.avaritia.common.item.tools.InfinityArmorItem;
import committee.nova.mods.avaritia.common.item.tools.infinity.InfinitySwordItem;
import committee.nova.mods.avaritia.common.net.S2CTotemPack;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModDataComponents;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.modes.InfinityMode;
import committee.nova.mods.avaritia.util.ToolUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.item.ItemExpireEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class InfinityHandler {
    @SubscribeEvent
    public static void onPlayerMine(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack item = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getEntity();
        Direction face = event.getFace();
        if (face == null || level.isClientSide || item.isEmpty() || player.isCreative()) {
            return;
        }
        if (item.is((Item)ModItems.crystal_pickaxe.get()) || item.is((Item)ModItems.infinity_pickaxe.get())) {
            if (state.is(Blocks.BEDROCK)) {
                level.setBlock(pos, ((Block)ModBlocks.fake_bedrock.get()).defaultBlockState(), 2);
            } else if (state.is(Blocks.END_PORTAL_FRAME)) {
                level.setBlock(pos, ((Block)ModBlocks.fake_end_portal_frame.get()).defaultBlockState(), 2);
            } else if (state.is(Blocks.END_PORTAL)) {
                level.setBlock(pos, ((Block)ModBlocks.fake_end_portal.get()).defaultBlockState(), 2);
            }
        }
        if (!item.is((Item)ModItems.crystal_pickaxe.get()) && !item.is((Item)ModItems.infinity_pickaxe.get())) {
            if (state.is((Block)ModBlocks.fake_bedrock.get())) {
                level.setBlock(pos, Blocks.BEDROCK.defaultBlockState(), 2);
            } else if (state.is((Block)ModBlocks.fake_end_portal_frame.get())) {
                level.setBlock(pos, Blocks.END_PORTAL_FRAME.defaultBlockState(), 2);
            } else if (state.is((Block)ModBlocks.fake_end_portal.get())) {
                level.setBlock(pos, Blocks.END_PORTAL.defaultBlockState(), 2);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerMine(BlockEvent.BreakEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        if (!event.getPlayer().isCreative()) {
            if (state.is((Block)ModBlocks.fake_bedrock.get())) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)Blocks.BEDROCK.asItem().getDefaultInstance());
            } else if (state.is((Block)ModBlocks.fake_end_portal_frame.get())) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)Blocks.END_PORTAL_FRAME.asItem().getDefaultInstance());
            } else if (state.is((Block)ModBlocks.fake_end_portal.get())) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)Blocks.END_PORTAL.asItem().getDefaultInstance());
            } else if (state.is(Blocks.REINFORCED_DEEPSLATE)) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)Blocks.REINFORCED_DEEPSLATE.asItem().getDefaultInstance());
            }
        }
    }

    @SubscribeEvent
    public static void digging(PlayerEvent.BreakSpeed event) {
        ItemStack held;
        if (!event.getEntity().getMainHandItem().isEmpty() && ((held = event.getEntity().getMainHandItem()).is((Item)ModItems.infinity_pickaxe.get()) || held.is((Item)ModItems.infinity_shovel.get()))) {
            if (!event.getEntity().onGround()) {
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
            }
            if (!event.getEntity().isInWater()) {
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
            }
            if (((InfinityMode)held.getOrDefault(ModDataComponents.INFINITY_MODE, (Object)InfinityMode.DEFAULT)).equals(InfinityMode.RANGE)) {
                event.setNewSpeed(event.getNewSpeed() * 0.5f);
            }
        }
    }

    @SubscribeEvent
    public static void clusterCluster(ItemEntityPickupEvent.Pre event) {
        Player player = event.getPlayer();
        ItemStack stack = event.getItemEntity().getItem();
        if (((Boolean)ModConfig.isMergeMatterCluster.get()).booleanValue() && event.getItemEntity().getItem().is((Item)ModItems.matter_cluster.get())) {
            boolean mergedAny = false;
            for (ItemStack slot : player.getInventory().items) {
                if (stack.isEmpty()) break;
                if (!slot.is((Item)ModItems.matter_cluster.get())) continue;
                mergedAny |= MatterClusterItem.mergeClusters(stack, slot);
            }
            if (mergedAny) {
                player.level().playSound(null, (Entity)player, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (player.level().random.nextFloat() - player.level().random.nextFloat()) * 1.4f + 2.0f);
            }
        }
    }

    @SubscribeEvent
    public static void expCancel(ItemExpireEvent event) {
        ItemEntity itemEntity = event.getEntity();
        if (itemEntity instanceof ImmortalItemEntity) {
            ImmortalItemEntity itemEntity2 = (ImmortalItemEntity)itemEntity;
            itemEntity2.setUnlimitedLifetime();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        block4: {
            block3: {
                Item item;
                if (!((Boolean)ModConfig.isSwordAttackEndless.get()).booleanValue() || !((item = event.getItemStack().getItem()) instanceof InfinitySwordItem)) break block3;
                InfinitySwordItem swordItem = (InfinitySwordItem)item;
                for (int x = 0; x < event.getToolTip().size(); ++x) {
                    if (!((Component)event.getToolTip().get(x)).getString().contains(I18n.get((String)"attribute.name.generic.attack_damage", (Object[])new Object[0]))) continue;
                    Boolean endlessDamage = (Boolean)ModConfig.isSwordAttackEndless.get();
                    event.getToolTip().set(x, Component.literal((String)(endlessDamage != false ? TextUtils.makeFabulous(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])) : String.valueOf(swordItem.getTier().getAttackDamageBonus()))).append(" ").append((Component)Component.translatable((String)"tooltip.infinity.desc").withStyle(ChatFormatting.DARK_GREEN)));
                    return;
                }
                break block4;
            }
            if (!(event.getItemStack().getItem() instanceof InfinityArmorItem)) break block4;
            for (int x = 0; x < event.getToolTip().size(); ++x) {
                if (((Component)event.getToolTip().get(x)).getString().contains(I18n.get((String)"attribute.name.generic.armor", (Object[])new Object[0]))) {
                    event.getToolTip().set(x, Component.literal((String)"+").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)TextUtils.makeFabulous(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])))).append(" ").append((Component)Component.translatable((String)"tooltip.armor.desc").withStyle(ChatFormatting.BLUE)));
                    return;
                }
                if (!((Component)event.getToolTip().get(x)).getString().contains(I18n.get((String)"attribute.name.generic.armor_toughness", (Object[])new Object[0]))) continue;
                event.getToolTip().set(x, Component.literal((String)"+").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)TextUtils.makeFabulous(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])))).append(" ").append((Component)Component.translatable((String)"tooltip.armor_toughness.desc").withStyle(ChatFormatting.BLUE)));
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (ToolUtils.isInfinite((LivingEntity)player)) {
                event.setCanceled(true);
                player.hurtTime = 0;
                player.deathTime = 0;
                player.setHealth(Math.max(20.0f, player.getMaxHealth()));
            } else {
                ItemStack totem = ToolUtils.getPlayerTotemItem((Player)player);
                if (!totem.isEmpty()) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new S2CTotemPack(totem, player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    player.removeAllEffects();
                    if (totem.getDamageValue() == 1) {
                        player.setHealth(player.getMaxHealth());
                        player.addEffect(new MobEffectInstance(MobEffects.JUMP, 800, 1));
                        player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 800, 1));
                        ToolUtils.aoeAttack((Player)player, 8.0f, 1000.0f, false, false);
                        player.displayClientMessage((Component)Component.translatable((String)"tooltip.avaritia.totem_break"), false);
                    } else {
                        player.setHealth(player.getMaxHealth());
                    }
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 2600, 4));
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 400, 1));
                    player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 700, 2));
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 1100, 0));
                    totem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onInfiniteHurt(LivingIncomingDamageEvent event) {
        Player player;
        DamageSource damageSource = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && ToolUtils.isInfinite((LivingEntity)(player = (Player)livingEntity)) && !damageSource.is(ModDamageTypes.INFINITY)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttackedInfinite(AttackEntityEvent event) {
        LivingEntity living;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity && ToolUtils.isInfinite(living = (LivingEntity)entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Player player;
        DamageSource damageSource = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && ToolUtils.isInfinite((LivingEntity)(player = (Player)livingEntity)) && !damageSource.is(ModDamageTypes.INFINITY)) {
            event.setNewDamage(0.0f);
            player.hurtTime = 0;
            player.deathTime = 0;
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Post event) {
        Player player;
        DamageSource damageSource = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && ToolUtils.isInfinite((LivingEntity)(player = (Player)livingEntity)) && !damageSource.is(ModDamageTypes.INFINITY)) {
            player.hurtTime = 0;
            player.deathTime = 0;
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        Player player;
        Entity entity;
        if (event.isRecentlyHit() && event.getEntity() instanceof AbstractSkeleton && (entity = event.getSource().getEntity()) instanceof Player && ((player = (Player)entity).getMainHandItem().is((Item)ModItems.blaze_sword.get()) || player.getOffhandItem().is((Item)ModItems.blaze_sword.get()))) {
            if (event.getDrops().isEmpty()) {
                InfinityHandler.addDrop(event, new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL));
            } else {
                int skulls = 0;
                for (ItemEntity drop : event.getDrops()) {
                    ItemStack stack = drop.getItem();
                    if (!stack.is(Items.WITHER_SKELETON_SKULL)) continue;
                    ++skulls;
                }
                if (skulls == 0) {
                    InfinityHandler.addDrop(event, new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL));
                }
            }
        }
    }

    private static void addDrop(LivingDropsEvent event, ItemStack drop) {
        ItemEntity entity = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), drop);
        entity.setDefaultPickUpDelay();
        event.getDrops().add(entity);
    }
}

