/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.registry.modes;

import com.mojang.serialization.Codec;
import committee.nova.mods.avaritia.api.common.item.iface.mode.IModeEnum;
import committee.nova.mods.avaritia.api.utils.text.IHasTranslationKey;
import committee.nova.mods.avaritia.init.registry.enums.ModLang;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public enum InfinityMode implements IModeEnum<InfinityMode>
{
    DEFAULT(ModLang.DEFAULT_MODE),
    RANGE(ModLang.RANGE_MODE);

    public static final Codec<InfinityMode> CODEC;
    public static final IntFunction<InfinityMode> BY_ID;
    public static final StreamCodec<ByteBuf, InfinityMode> STREAM_CODEC;
    private final IHasTranslationKey langEntry;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);

    private InfinityMode(IHasTranslationKey langEntry) {
        this.langEntry = langEntry;
    }

    @NotNull
    public String getSerializedName() {
        return this.serializedName;
    }

    @Override
    public String getTranslationKey() {
        return this.langEntry.getTranslationKey();
    }

    @Override
    public InfinityMode next(ItemStack stack) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> RANGE;
            case 1 -> DEFAULT;
        };
    }

    static {
        CODEC = StringRepresentable.fromEnum(InfinityMode::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])InfinityMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

