/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.registry.modes;

import com.mojang.serialization.Codec;
import committee.nova.mods.avaritia.api.common.item.iface.mode.IModeEnum;
import committee.nova.mods.avaritia.api.utils.text.IHasTranslationKey;
import committee.nova.mods.avaritia.init.registry.enums.ModLang;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public enum ToolMode implements IModeEnum<ToolMode>
{
    DEFAULT(ModLang.DEFAULT_MODE),
    ADVANCE(ModLang.ADVANCE_MODE);

    public static final Codec<ToolMode> CODEC;
    public static final IntFunction<ToolMode> BY_ID;
    public static final StreamCodec<ByteBuf, ToolMode> STREAM_CODEC;
    private final IHasTranslationKey langEntry;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);

    private ToolMode(IHasTranslationKey langEntry) {
        this.langEntry = langEntry;
    }

    @NotNull
    public String getSerializedName() {
        return this.serializedName;
    }

    @Override
    public String getTranslationKey() {
        return this.langEntry.getTranslationKey();
    }

    @Override
    public ToolMode next(ItemStack stack) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> DEFAULT;
            case 0 -> ADVANCE;
        };
    }

    static {
        CODEC = StringRepresentable.fromEnum(ToolMode::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ToolMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

