/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import com.google.common.collect.Sets;
import committee.nova.mods.avaritia.api.utils.ItemUtils;
import committee.nova.mods.avaritia.common.item.resources.MatterClusterItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ClustersUtils {
    public static Set<String> defaultTrashOres = Sets.newHashSet((Object[])new String[]{"minecraft:dirt"});

    public static void spawnClusters(Level world, Player player, Set<ItemStack> drops) {
        if (!world.isClientSide) {
            Containers.dropItemStack((Level)world, (double)player.getX(), (double)(player.getY() + 0.5), (double)player.getZ(), (ItemStack)MatterClusterItem.makeClusters(drops));
        }
    }

    public static void spawnClusters(Level world, Player player, Map<ItemStack, Integer> map) {
        if (!world.isClientSide) {
            HashSet<ItemStack> stacks = new HashSet<ItemStack>();
            Containers.dropItemStack((Level)world, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)MatterClusterItem.makeClusters(stacks));
        }
    }

    public static void putMapItem(ItemStack drop, Map<ItemStack, Integer> map) {
        ItemStack itemStack = ItemUtils.mapEquals(drop, map);
        if (!itemStack.isEmpty()) {
            map.put(itemStack, map.get(itemStack) + drop.getCount());
        } else {
            map.put(drop, drop.getCount());
        }
    }

    public static void putMapDrops(Level world, BlockPos pos, Player player, ItemStack stack, Map<ItemStack, Integer> map) {
        for (ItemStack drop : Block.getDrops((BlockState)world.getBlockState(pos), (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)player, (ItemStack)stack)) {
            ClustersUtils.putMapItem(drop, map);
        }
    }

    public static Set<ItemStack> removeTrash(Set<ItemStack> drops, Set<String> defaultTrashOres) {
        HashSet<ItemStack> trashItems = new HashSet<ItemStack>();
        for (ItemStack drop : drops) {
            if (!ClustersUtils.isTrash(drop, defaultTrashOres)) continue;
            trashItems.add(drop);
        }
        drops.removeAll(trashItems);
        return drops;
    }

    private static boolean isTrash(ItemStack suspect, Set<String> defaultTrashOres) {
        boolean isTrash = false;
        for (String ore : defaultTrashOres) {
            if (!suspect.is((Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)ore)))) continue;
            return true;
        }
        return isTrash;
    }

    public static List<ItemStack> collateDropList(Set<ItemStack> input) {
        return ClustersUtils.collateMatterClusterContents(ClustersUtils.collateMatterCluster(input));
    }

    public static List<ItemStack> collateMatterClusterContents(Map<ItemStack, Integer> input) {
        ArrayList<ItemStack> collated = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, Integer> e : input.entrySet()) {
            int count = e.getValue();
            ItemStack wrap = e.getKey();
            int size = wrap.getMaxStackSize();
            int fullstacks = Mth.floor((float)((float)count / (float)size));
            for (int i = 0; i < fullstacks; ++i) {
                count -= size;
                ItemStack stack = wrap.copy();
                stack.setCount(size);
                collated.add(stack);
            }
            if (count <= 0) continue;
            ItemStack stack = wrap.copy();
            stack.setCount(count);
            collated.add(stack);
        }
        return collated;
    }

    public static Map<ItemStack, Integer> collateMatterCluster(Set<ItemStack> input) {
        HashMap<ItemStack, Integer> counts = new HashMap<ItemStack, Integer>();
        if (input != null) {
            for (ItemStack entity : input) {
                ItemStack wrap = new ItemStack((ItemLike)entity.getItem());
                if (!counts.containsKey(wrap)) {
                    counts.put(wrap, 0);
                }
                counts.put(wrap, (Integer)counts.get(wrap) + entity.getCount());
            }
        }
        return counts;
    }
}

