/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.item.singularity.Singularity;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.handler.SingularityRegistryHandler;
import committee.nova.mods.avaritia.init.registry.ModDataComponents;
import committee.nova.mods.avaritia.init.registry.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;

public class SingularityUtils {
    public static Singularity loadFromJson(ResourceLocation id, JsonObject json) {
        Singularity singularity;
        if (!ICondition.conditionsMatched((DynamicOps)JsonOps.INSTANCE, (Object)json)) {
            Const.LOGGER.info("Skipping loading Singularity {} as its conditions were not met!", (Object)id);
            return null;
        }
        String name = GsonHelper.getAsString((JsonObject)json, (String)"name");
        JsonArray colors = GsonHelper.getAsJsonArray((JsonObject)json, (String)"colors");
        int materialCount = Const.isLoad("projecte") ? 10000 : GsonHelper.getAsInt((JsonObject)json, (String)"materialCount", (int)1000);
        int overlayColor = Integer.parseInt(colors.get(0).getAsString(), 16);
        int underlayColor = Integer.parseInt(colors.get(1).getAsString(), 16);
        int time = GsonHelper.getAsInt((JsonObject)json, (String)"timeRequired", (int)((Integer)ModConfig.singularityTimeRequired.get()));
        JsonObject ing = GsonHelper.getAsJsonObject((JsonObject)json, (String)"ingredient", null);
        boolean enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled", (boolean)true);
        boolean recipeDisabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"recipeDisabled", (boolean)false);
        if (ing == null) {
            singularity = new Singularity(id, name, new int[]{overlayColor, underlayColor}, Ingredient.EMPTY, materialCount, time);
        } else if (ing.has("tag")) {
            String tag = ing.get("tag").getAsString();
            singularity = new Singularity(id, name, new int[]{overlayColor, underlayColor}, tag, materialCount, time);
        } else {
            Ingredient ingredient = (Ingredient)((Pair)Ingredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.get("ingredient")).getOrThrow()).getFirst();
            singularity = new Singularity(id, name, new int[]{overlayColor, underlayColor}, ingredient, materialCount, time);
        }
        singularity.setEnabled(enabled);
        singularity.setRecipeEnabled(!recipeDisabled);
        return singularity;
    }

    public static JsonObject writeToJson(Singularity singularity) {
        JsonElement ingredient;
        JsonObject json = new JsonObject();
        json.addProperty("name", singularity.getName());
        JsonArray colors = new JsonArray();
        colors.add(Integer.toHexString(singularity.getOverlayColor() & 0xFFFFFF));
        colors.add(Integer.toHexString(singularity.getUnderlayColor() & 0xFFFFFF));
        json.add("colors", (JsonElement)colors);
        json.addProperty("timeRequired", (Number)singularity.getTimeRequired());
        if (singularity.getTag() != null) {
            JsonObject obj = new JsonObject();
            obj.addProperty("tag", singularity.getTag());
            ingredient = obj;
            JsonArray array = new JsonArray();
            JsonObject main = new JsonObject();
            JsonObject sub = new JsonObject();
            main.addProperty("type", "neoforge:not");
            sub.addProperty("tag", singularity.getTag());
            sub.addProperty("type", "neoforge:tag_empty");
            main.add("value", (JsonElement)sub);
            array.add((JsonElement)main);
            json.add("neoforge:conditions", (JsonElement)array);
        } else {
            ingredient = Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)singularity.getIngredient()).result().orElse(null);
        }
        json.add("ingredient", ingredient);
        json.addProperty("enabled", Boolean.valueOf(singularity.isEnabled()));
        json.addProperty("recipeEnabled", Boolean.valueOf(singularity.isRecipeEnabled()));
        return json;
    }

    public static ItemStack getItemForSingularity(Singularity singularity) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.singularity.get());
        stack.set(ModDataComponents.SINGULARITY_ID, (Object)singularity.getId());
        return stack;
    }

    public static Singularity getSingularity(ItemStack stack) {
        ResourceLocation id = (ResourceLocation)stack.get(ModDataComponents.SINGULARITY_ID);
        if (id != null) {
            return SingularityRegistryHandler.getInstance().getSingularityById(id);
        }
        return null;
    }
}

