/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.ai.brain;

import me.jellysquid.mods.lithium.mixin.ai.useless_sensors.BrainAccessor;
import me.jellysquid.mods.lithium.mixin.ai.useless_sensors.SensorAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;

public class SensorHelper {
    public static void disableSensor(LivingEntity brainedEntity, SensorType<?> sensorType) {
        if (brainedEntity.level().isClientSide()) {
            return;
        }
        Brain brain = brainedEntity.getBrain();
        Sensor sensor = ((BrainAccessor)brain).getSensors().get(sensorType);
        if (sensor instanceof SensorAccessor) {
            SensorAccessor sensorAccessor = (SensorAccessor)sensor;
            long lastSenseTime = sensorAccessor.getLastSenseTime();
            int senseInterval = sensorAccessor.getSenseInterval();
            long maxMultipleOfSenseInterval = Long.MAX_VALUE - Long.MAX_VALUE % (long)senseInterval;
            maxMultipleOfSenseInterval -= (long)senseInterval;
            sensorAccessor.setLastSenseTime(maxMultipleOfSenseInterval += lastSenseTime);
        }
    }

    public static <T extends LivingEntity, U extends Sensor<T>> void enableSensor(T brainedEntity, SensorType<U> sensorType) {
        SensorHelper.enableSensor(brainedEntity, sensorType, false);
    }

    public static <T extends LivingEntity, U extends Sensor<T>> void enableSensor(T brainedEntity, SensorType<U> sensorType, boolean extraTick) {
        if (brainedEntity.level().isClientSide()) {
            return;
        }
        Brain brain = brainedEntity.getBrain();
        Sensor sensor = ((BrainAccessor)brain).getSensors().get(sensorType);
        if (sensor instanceof SensorAccessor) {
            int senseInterval;
            SensorAccessor sensorAccessor = (SensorAccessor)sensor;
            long lastSenseTime = sensorAccessor.getLastSenseTime();
            if (lastSenseTime > (long)(senseInterval = sensorAccessor.getSenseInterval())) {
                lastSenseTime %= (long)senseInterval;
                if (extraTick) {
                    ((SensorAccessor)sensor).setLastSenseTime(0L);
                    sensor.tick((ServerLevel)brainedEntity.level(), brainedEntity);
                }
            }
            sensorAccessor.setLastSenseTime(lastSenseTime);
        }
    }
}

