/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.block_tracking;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.util.ArrayList;
import me.jellysquid.mods.lithium.common.block.BlockListeningSection;
import me.jellysquid.mods.lithium.common.block.BlockStateFlags;
import me.jellysquid.mods.lithium.common.block.ListeningBlockStatePredicate;
import me.jellysquid.mods.lithium.common.entity.block_tracking.SectionedBlockChangeTracker;
import me.jellysquid.mods.lithium.common.util.Pos;
import me.jellysquid.mods.lithium.common.world.LithiumData;
import me.jellysquid.mods.lithium.common.world.chunk.ChunkStatusTracker;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.LevelChunkSection;

public final class ChunkSectionChangeCallback {
    private final ArrayList<SectionedBlockChangeTracker>[] trackers = new ArrayList[BlockStateFlags.NUM_LISTENING_FLAGS];
    private short listeningMask = 0;

    public static ChunkSectionChangeCallback create(long sectionPos, Level world) {
        ChunkSectionChangeCallback chunkSectionChangeCallback = new ChunkSectionChangeCallback();
        Long2ReferenceOpenHashMap<ChunkSectionChangeCallback> changeCallbacks = ((LithiumData)world).lithium$getData().chunkSectionChangeCallbacks();
        ChunkSectionChangeCallback previous = (ChunkSectionChangeCallback)changeCallbacks.put(sectionPos, (Object)chunkSectionChangeCallback);
        if (previous != null) {
            previous.onChunkSectionInvalidated(SectionPos.of((long)sectionPos));
        }
        return chunkSectionChangeCallback;
    }

    public short onBlockChange(int blockGroupIndex, BlockListeningSection section) {
        ArrayList<SectionedBlockChangeTracker> sectionedBlockChangeTrackers = this.trackers[blockGroupIndex];
        this.trackers[blockGroupIndex] = null;
        if (sectionedBlockChangeTrackers != null) {
            for (int i = 0; i < sectionedBlockChangeTrackers.size(); ++i) {
                sectionedBlockChangeTrackers.get(i).setChanged(section);
            }
        }
        this.listeningMask = (short)(this.listeningMask & (short)(~(1 << blockGroupIndex)));
        return this.listeningMask;
    }

    public short addTracker(SectionedBlockChangeTracker tracker, ListeningBlockStatePredicate blockGroup) {
        int blockGroupIndex = blockGroup.getIndex();
        ArrayList<SectionedBlockChangeTracker> sectionedBlockChangeTrackers = this.trackers[blockGroupIndex];
        if (sectionedBlockChangeTrackers == null) {
            this.trackers[blockGroupIndex] = sectionedBlockChangeTrackers = new ArrayList();
        }
        sectionedBlockChangeTrackers.add(tracker);
        this.listeningMask = (short)(this.listeningMask | (short)(1 << blockGroupIndex));
        return this.listeningMask;
    }

    public short removeTracker(SectionedBlockChangeTracker tracker, ListeningBlockStatePredicate blockGroup) {
        int blockGroupIndex = blockGroup.getIndex();
        ArrayList<SectionedBlockChangeTracker> sectionedBlockChangeTrackers = this.trackers[blockGroupIndex];
        if (sectionedBlockChangeTrackers != null) {
            sectionedBlockChangeTrackers.remove(tracker);
            if (sectionedBlockChangeTrackers.isEmpty()) {
                this.listeningMask = (short)(this.listeningMask & (short)(~(1 << blockGroup.getIndex())));
            }
        }
        return this.listeningMask;
    }

    public void onChunkSectionInvalidated(SectionPos sectionPos) {
        for (int flagIndex = 0; flagIndex < this.trackers.length; ++flagIndex) {
            ArrayList<SectionedBlockChangeTracker> sectionedBlockChangeTrackers = this.trackers[flagIndex];
            this.trackers[flagIndex] = null;
            if (sectionedBlockChangeTrackers == null) continue;
            for (int i = 0; i < sectionedBlockChangeTrackers.size(); ++i) {
                sectionedBlockChangeTrackers.get(i).onChunkSectionInvalidated(sectionPos);
            }
        }
        this.listeningMask = 0;
    }

    static {
        if (BlockListeningSection.class.isAssignableFrom(LevelChunkSection.class)) {
            ChunkStatusTracker.registerUnloadCallback((serverWorld, chunkPos) -> {
                Long2ReferenceOpenHashMap<ChunkSectionChangeCallback> changeCallbacks = ((LithiumData)serverWorld).lithium$getData().chunkSectionChangeCallbacks();
                int x = chunkPos.x;
                int z = chunkPos.z;
                for (int y = Pos.SectionYCoord.getMinYSection((LevelHeightAccessor)serverWorld); y <= Pos.SectionYCoord.getMaxYSectionInclusive((LevelHeightAccessor)serverWorld); ++y) {
                    SectionPos chunkSectionPos = SectionPos.of((int)x, (int)y, (int)z);
                    ChunkSectionChangeCallback chunkSectionChangeCallback = (ChunkSectionChangeCallback)changeCallbacks.remove(chunkSectionPos.asLong());
                    if (chunkSectionChangeCallback == null) continue;
                    chunkSectionChangeCallback.onChunkSectionInvalidated(chunkSectionPos);
                }
            });
        }
    }
}

