/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.item;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import me.jellysquid.mods.lithium.mixin.util.accessors.ItemEntityAccessor;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class ItemEntityLazyIterationConsumer
implements AbortableIterationConsumer<ItemEntity> {
    private final ItemStack stack;
    private final AABB box;
    private final Predicate<ItemEntity> predicate;
    private final ArrayList<ItemEntity> mergeEntities;
    private final ItemEntity searchingEntity;
    private int adjustedStackCount;

    public ItemEntityLazyIterationConsumer(ItemEntity searchingEntity, AABB box, Predicate<ItemEntity> predicate) {
        this.searchingEntity = searchingEntity;
        this.box = box;
        this.predicate = predicate;
        this.mergeEntities = new ArrayList();
        this.stack = this.searchingEntity.getItem();
        this.adjustedStackCount = this.stack.getCount();
    }

    public ArrayList<ItemEntity> getMergeEntities() {
        return this.mergeEntities;
    }

    public AbortableIterationConsumer.Continuation accept(ItemEntity otherItemEntity) {
        if (!this.box.intersects(otherItemEntity.getBoundingBox()) || !this.predicate.test(otherItemEntity)) {
            return AbortableIterationConsumer.Continuation.CONTINUE;
        }
        int receivedItemCount = ItemEntityLazyIterationConsumer.predictReceivedItemCount(this.searchingEntity, this.stack, this.adjustedStackCount, otherItemEntity);
        if (receivedItemCount != 0) {
            this.mergeEntities.add(otherItemEntity);
            this.adjustedStackCount += receivedItemCount;
            if (this.adjustedStackCount <= 0 || this.adjustedStackCount >= this.stack.getMaxStackSize()) {
                return AbortableIterationConsumer.Continuation.ABORT;
            }
        }
        return AbortableIterationConsumer.Continuation.CONTINUE;
    }

    private static int predictReceivedItemCount(ItemEntity thisEntity, ItemStack thisStack, int adjustedStackCount, ItemEntity otherEntity) {
        ItemStack otherStack;
        if (Objects.equals(((ItemEntityAccessor)thisEntity).lithium$getOwner(), ((ItemEntityAccessor)otherEntity).lithium$getOwner()) && ItemEntity.areMergable((ItemStack)thisStack, (ItemStack)(otherStack = otherEntity.getItem()))) {
            if (otherStack.getCount() < adjustedStackCount) {
                return ItemEntityLazyIterationConsumer.getTransferAmount(thisStack.getMaxStackSize(), adjustedStackCount, otherStack.getCount());
            }
            return -ItemEntityLazyIterationConsumer.getTransferAmount(otherStack.getMaxStackSize(), otherStack.getCount(), adjustedStackCount);
        }
        return 0;
    }

    private static int getTransferAmount(int maxCount, int targetStackCount, int sourceStackCount) {
        return Math.min(Math.min(maxCount, 64) - targetStackCount, sourceStackCount);
    }
}

