/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.hopper;

import me.jellysquid.mods.lithium.api.inventory.LithiumTransferConditionInventory;
import me.jellysquid.mods.lithium.common.hopper.ComparatorUpdatePattern;
import me.jellysquid.mods.lithium.common.hopper.LithiumDoubleInventory;
import me.jellysquid.mods.lithium.common.hopper.LithiumStackList;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import org.jetbrains.annotations.Nullable;

public class HopperHelper {
    public static boolean tryMoveSingleItem(Container to, ItemStack stack, @Nullable Direction fromDirection) {
        WorldlyContainer toSided;
        ItemStack transferChecker;
        if (((LithiumTransferConditionInventory)to).lithium$itemInsertionTestRequiresStackSize1()) {
            transferChecker = stack.copy();
            transferChecker.setCount(1);
        } else {
            transferChecker = stack;
        }
        WorldlyContainer worldlyContainer = toSided = to instanceof WorldlyContainer ? (WorldlyContainer)to : null;
        if (toSided != null && fromDirection != null) {
            int[] slots = toSided.getSlotsForFace(fromDirection);
            for (int slotIndex = 0; slotIndex < slots.length; ++slotIndex) {
                if (!HopperHelper.tryMoveSingleItem(to, toSided, stack, transferChecker, slots[slotIndex], fromDirection)) continue;
                return true;
            }
        } else {
            int j = to.getContainerSize();
            for (int slot = 0; slot < j; ++slot) {
                if (!HopperHelper.tryMoveSingleItem(to, toSided, stack, transferChecker, slot, fromDirection)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean tryMoveSingleItem(Container to, @Nullable WorldlyContainer toSided, ItemStack transferStack, ItemStack transferChecker, int targetSlot, @Nullable Direction fromDirection) {
        ItemStack toStack = to.getItem(targetSlot);
        if (to.canPlaceItem(targetSlot, transferChecker) && (toSided == null || toSided.canPlaceItemThroughFace(targetSlot, transferChecker, fromDirection))) {
            if (toStack.isEmpty()) {
                ItemStack singleItem = transferStack.split(1);
                to.setItem(targetSlot, singleItem);
                return true;
            }
            int toCount = toStack.getCount();
            if (toStack.getMaxStackSize() > toCount && to.getMaxStackSize() > toCount && ItemStack.isSameItemSameComponents((ItemStack)toStack, (ItemStack)transferStack)) {
                transferStack.shrink(1);
                toStack.grow(1);
                return true;
            }
        }
        return false;
    }

    private static int calculateReducedSignalStrength(float contentWeight, int inventorySize, int inventoryMaxCountPerStack, int numOccupiedSlots, int itemStackCount, int itemStackMaxCount) {
        int maxStackSize = Math.min(inventoryMaxCountPerStack, itemStackMaxCount);
        int newNumOccupiedSlots = numOccupiedSlots - (itemStackCount == 1 ? 1 : 0);
        float newContentWeight = contentWeight - 1.0f / (float)maxStackSize;
        return Mth.floor((float)((newContentWeight /= (float)inventorySize) * 14.0f)) + (newNumOccupiedSlots > 0 ? 1 : 0);
    }

    public static ComparatorUpdatePattern determineComparatorUpdatePattern(Container from, LithiumStackList fromStackList) {
        int newSignalStrength;
        int fromSlot;
        ItemStack itemStack;
        if (from instanceof HopperBlockEntity || !(from instanceof RandomizableContainerBlockEntity)) {
            return ComparatorUpdatePattern.NO_UPDATE;
        }
        float contentWeight = 0.0f;
        int numOccupiedSlots = 0;
        for (int j = 0; j < from.getContainerSize(); ++j) {
            ItemStack itemStack2 = from.getItem(j);
            if (itemStack2.isEmpty()) continue;
            int maxStackSize = Math.min(from.getMaxStackSize(), itemStack2.getMaxStackSize());
            contentWeight += (float)itemStack2.getCount() / (float)maxStackSize;
            ++numOccupiedSlots;
        }
        float f = contentWeight;
        int originalSignalStrength = Mth.floor((float)((f /= (float)from.getContainerSize()) * 14.0f)) + (numOccupiedSlots > 0 ? 1 : 0);
        ComparatorUpdatePattern updatePattern = ComparatorUpdatePattern.NO_UPDATE;
        int[] availableSlots = from instanceof WorldlyContainer ? ((WorldlyContainer)from).getSlotsForFace(Direction.DOWN) : null;
        WorldlyContainer sidedInventory = from instanceof WorldlyContainer ? (WorldlyContainer)from : null;
        int fromSize = availableSlots != null ? availableSlots.length : from.getContainerSize();
        for (int i = 0; i < fromSize && ((itemStack = (ItemStack)fromStackList.get(fromSlot = availableSlots != null ? availableSlots[i] : i)).isEmpty() || sidedInventory != null && !sidedInventory.canTakeItemThroughFace(fromSlot, itemStack, Direction.DOWN) || (updatePattern = (newSignalStrength = HopperHelper.calculateReducedSignalStrength(contentWeight, from.getContainerSize(), from.getMaxStackSize(), numOccupiedSlots, itemStack.getCount(), itemStack.getMaxStackSize())) != originalSignalStrength ? updatePattern.thenDecrementUpdateIncrementUpdate() : updatePattern.thenUpdate()).isChainable()); ++i) {
        }
        return updatePattern;
    }

    public static Container replaceDoubleInventory(Container blockInventory) {
        if (blockInventory instanceof CompoundContainer) {
            CompoundContainer doubleInventory = (CompoundContainer)blockInventory;
            if ((doubleInventory = LithiumDoubleInventory.getLithiumInventory(doubleInventory)) != null) {
                return doubleInventory;
            }
        }
        return blockInventory;
    }
}

