/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.reflection;

import java.util.WeakHashMap;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectionUtil {
    private static final String REMAPPED_ON_ENTITY_COLLISION = FMLLoader.isProduction() ? "entityInside" : "onEntityCollision";
    private static final WeakHashMap<Class<?>, Boolean> CACHED_IS_ENTITY_TOUCHABLE = new WeakHashMap();

    public static boolean hasMethodOverride(Class<?> clazz, Class<?> superclass, boolean fallbackResult, String methodName, Class<?> ... methodArgs) {
        while (clazz != null && clazz != superclass && superclass.isAssignableFrom(clazz)) {
            try {
                clazz.getDeclaredMethod(methodName, methodArgs);
                return true;
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
            catch (NoClassDefFoundError | RuntimeException error) {
                Logger logger = LogManager.getLogger((String)"Radium Class Analysis");
                logger.warn("Radium Class Analysis Error: Class " + clazz.getName() + " cannot be analysed, because getting declared methods crashes with " + error.getClass().getSimpleName() + ": " + error.getMessage() + ". This is usually caused by modded entities declaring methods that have a return type or parameter type that is annotated with @OnlyIn(Dist.CLIENT). Loading the type is not possible, because it only exists in the CLIENT environment. The recommended fix is to annotate the method with this argument or return type with the same annotation. Lithium handles this error by assuming the class cannot be included in some optimizations.");
                return fallbackResult;
            }
            catch (Throwable e) {
                String crashedClass = clazz.getName();
                CrashReport crashReport = CrashReport.forThrowable((Throwable)e, (String)"Radium Class Analysis");
                CrashReportCategory crashReportSection = crashReport.addCategory(e.getClass().toString() + " when getting declared methods.");
                crashReportSection.setDetail("Analyzed class", (Object)crashedClass);
                crashReportSection.setDetail("Analyzed method name", (Object)methodName);
                crashReportSection.setDetail("Analyzed method args", methodArgs);
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public static boolean isBlockStateEntityTouchable(BlockState operand) {
        Class<?> blockClazz = operand.getBlock().getClass();
        Boolean result = CACHED_IS_ENTITY_TOUCHABLE.get(blockClazz);
        if (result != null) {
            return result;
        }
        boolean res = ReflectionUtil.hasMethodOverride(blockClazz, BlockBehaviour.class, true, REMAPPED_ON_ENTITY_COLLISION, BlockState.class, Level.class, BlockPos.class, Entity.class);
        CACHED_IS_ENTITY_TOUCHABLE.put(blockClazz, res);
        return res;
    }
}

