/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import me.jellysquid.mods.lithium.common.shapes.CuboidVoxelSet;
import me.jellysquid.mods.lithium.common.shapes.VoxelShapeAlignedCuboidOffset;
import me.jellysquid.mods.lithium.common.shapes.VoxelShapeSimpleCube;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeAlignedCuboid
extends VoxelShapeSimpleCube {
    static final double LARGE_EPSILON = 1.0E-6;
    protected final byte xyzResolution;

    public VoxelShapeAlignedCuboid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int xRes, int yRes, int zRes) {
        super(new CuboidVoxelSet(1 << xRes, 1 << yRes, 1 << zRes, minX, minY, minZ, maxX, maxY, maxZ), minX, minY, minZ, maxX, maxY, maxZ);
        if (xRes > 3 || yRes > 3 || zRes > 3 || xRes < 0 || yRes < 0 || zRes < 0) {
            throw new IllegalArgumentException("Resolution must be between 0 and 3");
        }
        this.xyzResolution = (byte)(xRes << 4 | yRes << 2 | zRes);
    }

    public VoxelShapeAlignedCuboid(DiscreteVoxelShape voxels, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, byte xyzResolution) {
        super(voxels, minX, minY, minZ, maxX, maxY, maxZ);
        this.xyzResolution = xyzResolution;
    }

    @Override
    public VoxelShape move(double x, double y, double z) {
        return new VoxelShapeAlignedCuboidOffset(this, this.shape, x, y, z);
    }

    @Override
    public double collideX(AxisCycle cycleDirection, AABB box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(AxisCycle dir, AABB box, double maxDist) {
        switch (dir) {
            case NONE: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minX, this.maxX, this.getXSegments(), box.minX, box.maxX, maxDist);
            }
            case FORWARD: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minZ, this.maxZ, this.getZSegments(), box.minZ, box.maxZ, maxDist);
            }
            case BACKWARD: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minY, this.maxY, this.getYSegments(), box.minY, box.maxY, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    private static double calculatePenetration(double aMin, double aMax, int segmentsPerUnit, double bMin, double bMax, double maxDist) {
        if (maxDist > 0.0) {
            double gap = aMin - bMax;
            if (gap >= -1.0E-7) {
                return Math.min(gap, maxDist);
            }
            if (segmentsPerUnit == 1) {
                return maxDist;
            }
            double wallPos = (double)Mth.ceil((double)((bMax - 1.0E-7) * (double)segmentsPerUnit)) / (double)segmentsPerUnit;
            if (wallPos < aMax - 1.0E-6) {
                return Math.min(maxDist, wallPos - bMax);
            }
            return maxDist;
        }
        double gap = aMax - bMin;
        if (gap <= 1.0E-7) {
            return Math.max(gap, maxDist);
        }
        if (segmentsPerUnit == 1) {
            return maxDist;
        }
        double wallPos = (double)Mth.floor((double)((bMin + 1.0E-7) * (double)segmentsPerUnit)) / (double)segmentsPerUnit;
        if (wallPos > aMin + 1.0E-6) {
            return Math.max(maxDist, wallPos - bMin);
        }
        return maxDist;
    }

    @Override
    public DoubleList getCoords(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> new CubePointRange(this.getXSegments());
            case Direction.Axis.Y -> new CubePointRange(this.getYSegments());
            case Direction.Axis.Z -> new CubePointRange(this.getZSegments());
        };
    }

    @Override
    protected double get(Direction.Axis axis, int index) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> (double)index / (double)this.getXSegments();
            case Direction.Axis.Y -> (double)index / (double)this.getYSegments();
            case Direction.Axis.Z -> (double)index / (double)this.getZSegments();
        };
    }

    @Override
    protected int findIndex(Direction.Axis axis, double coord) {
        int i = switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> this.getXSegments();
            case Direction.Axis.Y -> this.getYSegments();
            case Direction.Axis.Z -> this.getZSegments();
        };
        return Mth.clamp((int)Mth.floor((double)(coord * (double)i)), (int)-1, (int)i);
    }

    protected int getXSegments() {
        return 1 << (this.xyzResolution >>> 4);
    }

    protected int getYSegments() {
        return 1 << (this.xyzResolution >>> 2 & 3);
    }

    protected int getZSegments() {
        return 1 << (this.xyzResolution & 3);
    }
}

