/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.block.hopper;

import me.jellysquid.mods.lithium.common.hopper.UpdateReceiver;
import me.jellysquid.mods.lithium.common.world.blockentity.BlockEntityGetter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HopperBlock.class})
public abstract class HopperBlockMixin
extends BaseEntityBlock {
    protected HopperBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Intrinsic
    public BlockState updateShape(BlockState myBlockState, Direction direction, BlockState newState, LevelAccessor world, BlockPos myPos, BlockPos posFrom) {
        return super.updateShape(myBlockState, direction, newState, world, myPos, posFrom);
    }

    @Inject(method={"getStateForNeighborUpdate(Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/Direction;Lnet/minecraft/block/BlockState;Lnet/minecraft/world/WorldAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;", "updateShape(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")}, remap=false)
    private void notifyOnNeighborUpdate(BlockState myBlockState, Direction direction, BlockState newState, LevelAccessor world, BlockPos myPos, BlockPos posFrom, CallbackInfoReturnable<BlockState> ci) {
        if (!world.isClientSide() && newState.getBlock() instanceof WorldlyContainerHolder) {
            this.updateHopper(world, myBlockState, myPos, posFrom);
        }
    }

    @Inject(method={"neighborChanged(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/BlockPos;Z)V"}, at={@At(value="HEAD")})
    private void updateBlockEntity(BlockState myBlockState, Level world, BlockPos myPos, Block block, BlockPos posFrom, boolean moved, CallbackInfo ci) {
        if (!world.isClientSide()) {
            this.updateHopper((LevelAccessor)world, myBlockState, myPos, posFrom);
        }
    }

    private void updateHopper(LevelAccessor world, BlockState myBlockState, BlockPos myPos, BlockPos posFrom) {
        BlockEntity hopper;
        boolean above;
        Direction facing = (Direction)myBlockState.getValue((Property)HopperBlock.FACING);
        boolean bl = above = posFrom.getY() == myPos.getY() + 1;
        if ((above || posFrom.getX() == myPos.getX() + facing.getStepX() && posFrom.getY() == myPos.getY() + facing.getStepY() && posFrom.getZ() == myPos.getZ() + facing.getStepZ()) && (hopper = ((BlockEntityGetter)world).lithium$getLoadedExistingBlockEntity(myPos)) instanceof UpdateReceiver) {
            UpdateReceiver updateReceiver = (UpdateReceiver)hopper;
            updateReceiver.lithium$invalidateCacheOnNeighborUpdate(above);
        }
    }

    @Inject(method={"onPlace(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/HopperBlock;checkPoweredState(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", shift=At.Shift.AFTER)})
    private void workAroundVanillaUpdateSuppression(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify, CallbackInfo ci) {
        if (world.getBlockState(pos) != state) {
            for (Direction direction : UPDATE_SHAPE_ORDER) {
                BlockEntity hopper = ((BlockEntityGetter)world).lithium$getLoadedExistingBlockEntity(pos.relative(direction));
                if (!(hopper instanceof UpdateReceiver)) continue;
                UpdateReceiver updateReceiver = (UpdateReceiver)hopper;
                updateReceiver.lithium$invalidateCacheOnNeighborUpdate(direction == Direction.DOWN);
            }
        }
    }
}

