/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.block.moving_block_shapes;

import me.jellysquid.mods.lithium.common.shapes.OffsetVoxelShapeCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PistonMovingBlockEntity.class})
public abstract class PistonBlockEntityMixin {
    private static final VoxelShape[] PISTON_BASE_WITH_MOVING_HEAD_SHAPES = PistonBlockEntityMixin.precomputePistonBaseWithMovingHeadShapes();
    @Shadow
    private Direction direction;
    @Shadow
    private boolean extending;
    @Shadow
    private boolean isSourcePiston;
    @Shadow
    private BlockState movedState;

    @Inject(method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/Direction;getStepX()I", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void skipVoxelShapeUnion(BlockGetter world, BlockPos pos, CallbackInfoReturnable<VoxelShape> cir, VoxelShape voxelShape, Direction direction, BlockState blockState, float f) {
        if (this.extending || !this.isSourcePiston || !(this.movedState.getBlock() instanceof PistonBaseBlock)) {
            VoxelShape blockShape = blockState.getCollisionShape(world, pos);
            VoxelShape offsetAndSimplified = PistonBlockEntityMixin.getOffsetAndSimplified(blockShape, Math.abs(f), f < 0.0f ? this.direction.getOpposite() : this.direction);
            cir.setReturnValue((Object)offsetAndSimplified);
        } else {
            int index = PistonBlockEntityMixin.getIndexForMergedShape(f, this.direction);
            cir.setReturnValue((Object)PISTON_BASE_WITH_MOVING_HEAD_SHAPES[index]);
        }
    }

    private static VoxelShape getOffsetAndSimplified(VoxelShape blockShape, float offset, Direction direction) {
        VoxelShape offsetSimplifiedShape = ((OffsetVoxelShapeCache)blockShape).lithium$getOffsetSimplifiedShape(offset, direction);
        if (offsetSimplifiedShape == null) {
            offsetSimplifiedShape = blockShape.move((double)((float)direction.getStepX() * offset), (double)((float)direction.getStepY() * offset), (double)((float)direction.getStepZ() * offset)).optimize();
            ((OffsetVoxelShapeCache)blockShape).lithium$setShape(offset, direction, offsetSimplifiedShape);
        }
        return offsetSimplifiedShape;
    }

    private static VoxelShape[] precomputePistonBaseWithMovingHeadShapes() {
        float[] offsets = new float[]{0.0f, 0.5f, 1.0f};
        Direction[] directions = Direction.values();
        VoxelShape[] mergedShapes = new VoxelShape[offsets.length * directions.length];
        for (Direction facing : directions) {
            VoxelShape baseShape = ((BlockState)((BlockState)Blocks.PISTON.defaultBlockState().setValue((Property)PistonBaseBlock.EXTENDED, (Comparable)Boolean.valueOf(true))).setValue((Property)PistonBaseBlock.FACING, (Comparable)facing)).getCollisionShape(null, null);
            for (float offset : offsets) {
                boolean isShort = offset < 0.25f;
                VoxelShape headShape = ((BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue((Property)PistonHeadBlock.FACING, (Comparable)facing)).setValue((Property)PistonHeadBlock.SHORT, (Comparable)Boolean.valueOf(isShort))).getCollisionShape(null, null);
                VoxelShape offsetHead = headShape.move((double)((float)facing.getStepX() * offset), (double)((float)facing.getStepY() * offset), (double)((float)facing.getStepZ() * offset));
                mergedShapes[PistonBlockEntityMixin.getIndexForMergedShape((float)offset, (Direction)facing)] = Shapes.or((VoxelShape)baseShape, (VoxelShape)offsetHead);
            }
        }
        return mergedShapes;
    }

    private static int getIndexForMergedShape(float offset, Direction direction) {
        if (offset != 0.0f && offset != 0.5f && offset != 1.0f) {
            return -1;
        }
        return (int)(2.0f * offset) + 3 * direction.get3DDataValue();
    }
}

