/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.util.item_component_and_count_tracking;

import me.jellysquid.mods.lithium.common.util.change_tracking.ChangePublisher;
import me.jellysquid.mods.lithium.common.util.change_tracking.ChangeSubscriber;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
implements ChangePublisher<ItemEntity>,
ChangeSubscriber.CountChangeSubscriber<ItemStack> {
    @Unique
    private ChangeSubscriber<ItemEntity> subscriber;
    @Unique
    private int subscriberData;

    @Shadow
    public abstract ItemStack getItem();

    @Unique
    private void startTrackingChanges() {
        ItemStack stack = this.getItem();
        if (!stack.isEmpty()) {
            ((ChangePublisher)stack).lithium$subscribe(this, 0);
        }
    }

    @Override
    public void lithium$subscribe(ChangeSubscriber<ItemEntity> subscriber, int subscriberData) {
        if (this.subscriber == null) {
            this.startTrackingChanges();
        }
        this.subscriber = ChangeSubscriber.combine(this.subscriber, this.subscriberData, subscriber, subscriberData);
        this.subscriberData = this.subscriber instanceof ChangeSubscriber.Multi ? 0 : subscriberData;
    }

    @Override
    public int lithium$unsubscribe(ChangeSubscriber<ItemEntity> subscriber) {
        ItemStack stack;
        int retval = ChangeSubscriber.dataOf(this.subscriber, subscriber, this.subscriberData);
        this.subscriberData = ChangeSubscriber.dataWithout(this.subscriber, subscriber, this.subscriberData);
        this.subscriber = ChangeSubscriber.without(this.subscriber, subscriber);
        if (this.subscriber == null && !(stack = this.getItem()).isEmpty()) {
            ((ChangePublisher)stack).lithium$unsubscribe(this);
        }
        return retval;
    }

    @Override
    public void lithium$notify(ItemStack publisher, int subscriberData) {
        if (publisher != this.getItem()) {
            throw new IllegalStateException("Received notification from an unexpected publisher");
        }
        if (this.subscriber != null) {
            this.subscriber.lithium$notify((ItemEntity)this, this.subscriberData);
        }
    }

    @Override
    public void lithium$forceUnsubscribe(ItemStack publisher, int subscriberData) {
        if (this.subscriber != null) {
            this.subscriber.lithium$forceUnsubscribe((ItemEntity)this, this.subscriberData);
            this.subscriber = null;
            this.subscriberData = 0;
        }
    }

    @Override
    public void lithium$notifyCount(ItemStack publisher, int subscriberData, int newCount) {
        if (publisher != this.getItem()) {
            throw new IllegalStateException("Received notification from an unexpected publisher");
        }
        ChangeSubscriber<ItemEntity> changeSubscriber = this.subscriber;
        if (changeSubscriber instanceof ChangeSubscriber.CountChangeSubscriber) {
            ChangeSubscriber.CountChangeSubscriber countChangeSubscriber = (ChangeSubscriber.CountChangeSubscriber)changeSubscriber;
            countChangeSubscriber.lithium$notifyCount((ItemEntity)this, this.subscriberData, newCount);
        }
    }

    @Inject(method={"setItem(Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")})
    private void beforeSetStack(ItemStack newStack, CallbackInfo ci) {
        ItemStack oldStack;
        if (this.subscriber != null && (oldStack = this.getItem()) != newStack) {
            if (!oldStack.isEmpty()) {
                ((ChangePublisher)oldStack).lithium$unsubscribe(this);
            }
            if (!newStack.isEmpty()) {
                ((ChangePublisher)newStack).lithium$subscribe(this, this.subscriberData);
                this.subscriber.lithium$notify((ItemEntity)this, this.subscriberData);
            } else {
                this.subscriber.lithium$forceUnsubscribe((ItemEntity)this, this.subscriberData);
                this.subscriber = null;
                this.subscriberData = 0;
            }
        }
    }
}

