/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.util.item_component_and_count_tracking;

import me.jellysquid.mods.lithium.common.util.change_tracking.ChangePublisher;
import me.jellysquid.mods.lithium.common.util.change_tracking.ChangeSubscriber;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements ChangePublisher<ItemStack>,
ChangeSubscriber<PatchedDataComponentMap> {
    @Shadow
    @Final
    PatchedDataComponentMap components;
    @Shadow
    private int count;
    @Unique
    private ChangeSubscriber<ItemStack> subscriber;
    @Unique
    private int subscriberData;

    @Shadow
    public abstract boolean isEmpty();

    @Override
    public void lithium$subscribe(ChangeSubscriber<ItemStack> subscriber, int subscriberData) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot subscribe to an empty ItemStack!");
        }
        if (this.subscriber == null) {
            this.startTrackingChanges();
        }
        this.subscriber = ChangeSubscriber.combine(this.subscriber, this.subscriberData, subscriber, subscriberData);
        this.subscriberData = this.subscriber instanceof ChangeSubscriber.Multi ? 0 : subscriberData;
    }

    @Override
    public int lithium$unsubscribe(ChangeSubscriber<ItemStack> subscriber) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot unsubscribe from an empty ItemStack!");
        }
        int retval = ChangeSubscriber.dataOf(this.subscriber, subscriber, this.subscriberData);
        this.subscriberData = ChangeSubscriber.dataWithout(this.subscriber, subscriber, this.subscriberData);
        this.subscriber = ChangeSubscriber.without(this.subscriber, subscriber);
        if (this.subscriber == null) {
            ((ChangePublisher)this.components).lithium$unsubscribe(this);
        }
        return retval;
    }

    @Override
    public void lithium$unsubscribeWithData(ChangeSubscriber<ItemStack> subscriber, int subscriberData) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot unsubscribe from an empty ItemStack!");
        }
        this.subscriberData = ChangeSubscriber.dataWithout(this.subscriber, subscriber, this.subscriberData, subscriberData, true);
        this.subscriber = ChangeSubscriber.without(this.subscriber, subscriber, subscriberData, true);
        if (this.subscriber == null) {
            ((ChangePublisher)this.components).lithium$unsubscribe(this);
        }
    }

    @Override
    public boolean lithium$isSubscribedWithData(ChangeSubscriber<ItemStack> subscriber, int subscriberData) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot be subscribed to an empty ItemStack!");
        }
        return ChangeSubscriber.containsSubscriber(this.subscriber, this.subscriberData, subscriber, subscriberData);
    }

    @Override
    public void lithium$forceUnsubscribe(PatchedDataComponentMap publisher, int subscriberData) {
        if (publisher != this.components) {
            throw new IllegalStateException("Invalid publisher, expected " + String.valueOf(this.components) + " but got " + String.valueOf(publisher));
        }
        this.subscriber.lithium$forceUnsubscribe((ItemStack)this, this.subscriberData);
        this.subscriber = null;
        this.subscriberData = 0;
    }

    @Unique
    private void startTrackingChanges() {
        ((ChangePublisher)this.components).lithium$subscribe(this, 0);
    }

    @Inject(method={"setCount(I)V"}, at={@At(value="HEAD")})
    private void beforeChangeCount(int count, CallbackInfo ci) {
        if (count != this.count) {
            ChangeSubscriber<ItemStack> changeSubscriber = this.subscriber;
            if (changeSubscriber instanceof ChangeSubscriber.CountChangeSubscriber) {
                ChangeSubscriber.CountChangeSubscriber countChangeSubscriber = (ChangeSubscriber.CountChangeSubscriber)changeSubscriber;
                countChangeSubscriber.lithium$notifyCount((ItemStack)this, this.subscriberData, count);
            }
            if (count == 0) {
                ((ChangePublisher)this.components).lithium$unsubscribe(this);
                if (this.subscriber != null) {
                    this.subscriber.lithium$forceUnsubscribe((ItemStack)this, this.subscriberData);
                    this.subscriber = null;
                    this.subscriberData = 0;
                }
            }
        }
    }

    @Override
    public void lithium$notify(PatchedDataComponentMap publisher, int subscriberData) {
        if (publisher != this.components) {
            throw new IllegalStateException("Invalid publisher, expected " + String.valueOf(this.components) + " but got " + String.valueOf(publisher));
        }
        if (this.subscriber != null) {
            this.subscriber.lithium$notify((ItemStack)this, this.subscriberData);
        }
    }

    @Inject(method={"set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;"}, at={@At(value="RETURN")})
    private <T> void onSetComponent(DataComponentType<? super T> type, @Nullable T value, CallbackInfoReturnable<T> cir) {
        ChangeSubscriber<ItemStack> changeSubscriber;
        if (type == DataComponents.ENCHANTMENTS && (changeSubscriber = this.subscriber) instanceof ChangeSubscriber.EnchantmentSubscriber) {
            ChangeSubscriber.EnchantmentSubscriber enchantmentSubscriber = (ChangeSubscriber.EnchantmentSubscriber)changeSubscriber;
            enchantmentSubscriber.lithium$notifyAfterEnchantmentChange((ItemStack)this, this.subscriberData);
        }
    }
}

