/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.client;

import appeng.client.gui.implementations.PatternProviderScreen;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.hooks.BuiltInModelHooks;
import appeng.init.client.InitScreens;
import lu.kolja.expandedae.Expandedae;
import lu.kolja.expandedae.client.render.ExpCraftingUnitModelProvider;
import lu.kolja.expandedae.definition.ExpMenus;
import lu.kolja.expandedae.enums.ExpTiers;
import lu.kolja.expandedae.screen.ExpIOPortScreen;
import lu.kolja.expandedae.terminal.ExpEncodingTerminalScreen;
import lu.kolja.expandedae.terminal.wtlib.ExpWETScreen;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

@Mod(value="expandedae", dist={Dist.CLIENT})
public class ExpandedaeClient {
    public ExpandedaeClient(IEventBus modEventBus) {
        ExpandedaeClient.initCraftingUnitModels();
        modEventBus.addListener(ExpandedaeClient::initScreens);
    }

    private static void initCraftingUnitModels() {
        for (ExpTiers tier : ExpTiers.values()) {
            String affix = tier.isCPU() ? tier.getCpuAffix() : tier.getAffix();
            BuiltInModelHooks.addBuiltInModel((ResourceLocation)Expandedae.makeId("block/crafting/" + affix + "_formed"), (UnbakedModel)new CraftingCubeModel((AbstractCraftingUnitModelProvider)new ExpCraftingUnitModelProvider(tier)));
        }
    }

    private static void initScreens(RegisterMenuScreensEvent event) {
        InitScreens.register((RegisterMenuScreensEvent)event, ExpMenus.EXP_PATTERN_PROVIDER.get(), PatternProviderScreen::new, (String)"/screens/exp_pattern_provider.json");
        InitScreens.register((RegisterMenuScreensEvent)event, ExpMenus.EXP_ENCODING_TERMINAL.get(), ExpEncodingTerminalScreen::new, (String)"/screens/terminals/exp_encoding_terminal.json");
        InitScreens.register((RegisterMenuScreensEvent)event, ExpMenus.EXP_IO_PORT.get(), ExpIOPortScreen::new, (String)"/screens/exp_io_port.json");
        ExpWETScreen.register(event);
    }
}

